/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the information for an ActiveMQ user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends MqRequest implements ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerId").getter(getter(UpdateUserRequest::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("broker-id").build()).build();

    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConsoleAccess").getter(getter(UpdateUserRequest::consoleAccess)).setter(setter(Builder::consoleAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(UpdateUserRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(UpdateUserRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UpdateUserRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("username").build()).build();

    private static final SdkField<Boolean> REPLICATION_USER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplicationUser").getter(getter(UpdateUserRequest::replicationUser))
            .setter(setter(Builder::replicationUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD,
            CONSOLE_ACCESS_FIELD, GROUPS_FIELD, PASSWORD_FIELD, USERNAME_FIELD, REPLICATION_USER_FIELD));

    private final String brokerId;

    private final Boolean consoleAccess;

    private final List<String> groups;

    private final String password;

    private final String username;

    private final Boolean replicationUser;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.password = builder.password;
        this.username = builder.username;
        this.replicationUser = builder.replicationUser;
    }

    /**
     * <p>
     * The unique ID that Amazon MQ generates for the broker.
     * </p>
     * 
     * @return The unique ID that Amazon MQ generates for the broker.
     */
    public final String brokerId() {
        return brokerId;
    }

    /**
     * <p>
     * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     * </p>
     * 
     * @return Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     */
    public final Boolean consoleAccess() {
        return consoleAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
     * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
     *         alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
     *         characters long.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The password of the user. This value must be at least 12 characters long, must contain at least 4 unique
     * characters, and must not contain commas, colons, or equal signs (,:=).
     * </p>
     * 
     * @return The password of the user. This value must be at least 12 characters long, must contain at least 4 unique
     *         characters, and must not contain commas, colons, or equal signs (,:=).
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods,
     * underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * </p>
     * 
     * @return The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods,
     *         underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Defines whether the user is intended for data replication.
     * </p>
     * 
     * @return Defines whether the user is intended for data replication.
     */
    public final Boolean replicationUser() {
        return replicationUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(replicationUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(brokerId(), other.brokerId()) && Objects.equals(consoleAccess(), other.consoleAccess())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(password(), other.password()) && Objects.equals(username(), other.username())
                && Objects.equals(replicationUser(), other.replicationUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("BrokerId", brokerId()).add("ConsoleAccess", consoleAccess())
                .add("Groups", hasGroups() ? groups() : null).add("Password", password()).add("Username", username())
                .add("ReplicationUser", replicationUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "ConsoleAccess":
            return Optional.ofNullable(clazz.cast(consoleAccess()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "ReplicationUser":
            return Optional.ofNullable(clazz.cast(replicationUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The unique ID that Amazon MQ generates for the broker.
         * </p>
         * 
         * @param brokerId
         *        The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * <p>
         * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * </p>
         * 
         * @param consoleAccess
         *        Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consoleAccess(Boolean consoleAccess);

        /**
         * <p>
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The password of the user. This value must be at least 12 characters long, must contain at least 4 unique
         * characters, and must not contain commas, colons, or equal signs (,:=).
         * </p>
         * 
         * @param password
         *        The password of the user. This value must be at least 12 characters long, must contain at least 4
         *        unique characters, and must not contain commas, colons, or equal signs (,:=).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods,
         * underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param username
         *        The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
         *        periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Defines whether the user is intended for data replication.
         * </p>
         * 
         * @param replicationUser
         *        Defines whether the user is intended for data replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationUser(Boolean replicationUser);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MqRequest.BuilderImpl implements Builder {
        private String brokerId;

        private Boolean consoleAccess;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String password;

        private String username;

        private Boolean replicationUser;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            brokerId(model.brokerId);
            consoleAccess(model.consoleAccess);
            groups(model.groups);
            password(model.password);
            username(model.username);
            replicationUser(model.replicationUser);
        }

        public final String getBrokerId() {
            return brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final Boolean getConsoleAccess() {
            return consoleAccess;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getReplicationUser() {
            return replicationUser;
        }

        public final void setReplicationUser(Boolean replicationUser) {
            this.replicationUser = replicationUser;
        }

        @Override
        public final Builder replicationUser(Boolean replicationUser) {
            this.replicationUser = replicationUser;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
