/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerInstanceOptionsRequest extends MqRequest implements
        ToCopyableBuilder<DescribeBrokerInstanceOptionsRequest.Builder, DescribeBrokerInstanceOptionsRequest> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(DescribeBrokerInstanceOptionsRequest::engineType))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("engineType").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostInstanceType").getter(getter(DescribeBrokerInstanceOptionsRequest::hostInstanceType))
            .setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostInstanceType").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeBrokerInstanceOptionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeBrokerInstanceOptionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(DescribeBrokerInstanceOptionsRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("storageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD,
            HOST_INSTANCE_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STORAGE_TYPE_FIELD));

    private final String engineType;

    private final String hostInstanceType;

    private final Integer maxResults;

    private final String nextToken;

    private final String storageType;

    private DescribeBrokerInstanceOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.engineType = builder.engineType;
        this.hostInstanceType = builder.hostInstanceType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.storageType = builder.storageType;
    }

    /**
     * <p>
     * Filter response by engine type.
     * </p>
     * 
     * @return Filter response by engine type.
     */
    public final String engineType() {
        return engineType;
    }

    /**
     * <p>
     * Filter response by host instance type.
     * </p>
     * 
     * @return Filter response by host instance type.
     */
    public final String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * <p>
     * The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer
     * from 5 to 100.
     * </p>
     * 
     * @return The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an
     *         integer from 5 to 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * </p>
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filter response by storage type.
     * </p>
     * 
     * @return Filter response by storage type.
     */
    public final String storageType() {
        return storageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineType());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerInstanceOptionsRequest)) {
            return false;
        }
        DescribeBrokerInstanceOptionsRequest other = (DescribeBrokerInstanceOptionsRequest) obj;
        return Objects.equals(engineType(), other.engineType()) && Objects.equals(hostInstanceType(), other.hostInstanceType())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(storageType(), other.storageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBrokerInstanceOptionsRequest").add("EngineType", engineType())
                .add("HostInstanceType", hostInstanceType()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("StorageType", storageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineType()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerInstanceOptionsRequest, T> g) {
        return obj -> g.apply((DescribeBrokerInstanceOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerInstanceOptionsRequest> {
        /**
         * <p>
         * Filter response by engine type.
         * </p>
         * 
         * @param engineType
         *        Filter response by engine type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * Filter response by host instance type.
         * </p>
         * 
         * @param hostInstanceType
         *        Filter response by host instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * <p>
         * The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an
         * integer from 5 to 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be
         *        an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filter response by storage type.
         * </p>
         * 
         * @param storageType
         *        Filter response by storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MqRequest.BuilderImpl implements Builder {
        private String engineType;

        private String hostInstanceType;

        private Integer maxResults;

        private String nextToken;

        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerInstanceOptionsRequest model) {
            super(model);
            engineType(model.engineType);
            hostInstanceType(model.hostInstanceType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            storageType(model.storageType);
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBrokerInstanceOptionsRequest build() {
            return new DescribeBrokerInstanceOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
