/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mq.DefaultMqAsyncClient;
import software.amazon.awssdk.services.mq.DefaultMqBaseClientBuilder;
import software.amazon.awssdk.services.mq.MqAsyncClient;
import software.amazon.awssdk.services.mq.MqAsyncClientBuilder;
import software.amazon.awssdk.services.mq.MqServiceClientConfiguration;
import software.amazon.awssdk.services.mq.endpoints.MqEndpointProvider;

@SdkInternalApi
final class DefaultMqAsyncClientBuilder
extends DefaultMqBaseClientBuilder<MqAsyncClientBuilder, MqAsyncClient>
implements MqAsyncClientBuilder {
    DefaultMqAsyncClientBuilder() {
    }

    @Override
    public DefaultMqAsyncClientBuilder endpointProvider(MqEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MqAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMqAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MqServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMqAsyncClient client = new DefaultMqAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MqServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MqServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

