/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the configuration element or attribute that was sanitized in the configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SanitizationWarning implements SdkPojo, Serializable,
        ToCopyableBuilder<SanitizationWarning.Builder, SanitizationWarning> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(SanitizationWarning::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ELEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElementName").getter(getter(SanitizationWarning::elementName)).setter(setter(Builder::elementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementName").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(SanitizationWarning::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ELEMENT_NAME_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String elementName;

    private final String reason;

    private SanitizationWarning(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.elementName = builder.elementName;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of the configuration attribute that has been sanitized.
     * </p>
     * 
     * @return The name of the configuration attribute that has been sanitized.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The name of the configuration element that has been sanitized.
     * </p>
     * 
     * @return The name of the configuration element that has been sanitized.
     */
    public final String elementName() {
        return elementName;
    }

    /**
     * <p>
     * The reason for which the configuration elements or attributes were sanitized.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SanitizationWarningReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for which the configuration elements or attributes were sanitized.
     * @see SanitizationWarningReason
     */
    public final SanitizationWarningReason reason() {
        return SanitizationWarningReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for which the configuration elements or attributes were sanitized.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SanitizationWarningReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for which the configuration elements or attributes were sanitized.
     * @see SanitizationWarningReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(elementName());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SanitizationWarning)) {
            return false;
        }
        SanitizationWarning other = (SanitizationWarning) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(elementName(), other.elementName())
                && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SanitizationWarning").add("AttributeName", attributeName()).add("ElementName", elementName())
                .add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ElementName":
            return Optional.ofNullable(clazz.cast(elementName()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributeName", ATTRIBUTE_NAME_FIELD);
        map.put("elementName", ELEMENT_NAME_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SanitizationWarning, T> g) {
        return obj -> g.apply((SanitizationWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SanitizationWarning> {
        /**
         * <p>
         * The name of the configuration attribute that has been sanitized.
         * </p>
         * 
         * @param attributeName
         *        The name of the configuration attribute that has been sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The name of the configuration element that has been sanitized.
         * </p>
         * 
         * @param elementName
         *        The name of the configuration element that has been sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementName(String elementName);

        /**
         * <p>
         * The reason for which the configuration elements or attributes were sanitized.
         * </p>
         * 
         * @param reason
         *        The reason for which the configuration elements or attributes were sanitized.
         * @see SanitizationWarningReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SanitizationWarningReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for which the configuration elements or attributes were sanitized.
         * </p>
         * 
         * @param reason
         *        The reason for which the configuration elements or attributes were sanitized.
         * @see SanitizationWarningReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SanitizationWarningReason
         */
        Builder reason(SanitizationWarningReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String elementName;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(SanitizationWarning model) {
            attributeName(model.attributeName);
            elementName(model.elementName);
            reason(model.reason);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getElementName() {
            return elementName;
        }

        public final void setElementName(String elementName) {
            this.elementName = elementName;
        }

        @Override
        public final Builder elementName(String elementName) {
            this.elementName = elementName;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SanitizationWarningReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public SanitizationWarning build() {
            return new SanitizationWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
