/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.BonusPaymentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a Bonus payment paid to a Worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BonusPayment implements StructuredPojo, ToCopyableBuilder<BonusPayment.Builder, BonusPayment> {
    private final String workerId;

    private final String bonusAmount;

    private final String assignmentId;

    private final String reason;

    private final Instant grantTime;

    private BonusPayment(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.bonusAmount = builder.bonusAmount;
        this.assignmentId = builder.assignmentId;
        this.reason = builder.reason;
        this.grantTime = builder.grantTime;
    }

    /**
     * <p>
     * The ID of the Worker to whom the bonus was paid.
     * </p>
     * 
     * @return The ID of the Worker to whom the bonus was paid.
     */
    public String workerId() {
        return workerId;
    }

    /**
     * Returns the value of the BonusAmount property for this object.
     * 
     * @return The value of the BonusAmount property for this object.
     */
    public String bonusAmount() {
        return bonusAmount;
    }

    /**
     * <p>
     * The ID of the assignment associated with this bonus payment.
     * </p>
     * 
     * @return The ID of the assignment associated with this bonus payment.
     */
    public String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * The Reason text given when the bonus was granted, if any.
     * </p>
     * 
     * @return The Reason text given when the bonus was granted, if any.
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * The date and time of when the bonus was granted.
     * </p>
     * 
     * @return The date and time of when the bonus was granted.
     */
    public Instant grantTime() {
        return grantTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(bonusAmount());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(grantTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BonusPayment)) {
            return false;
        }
        BonusPayment other = (BonusPayment) obj;
        return Objects.equals(workerId(), other.workerId()) && Objects.equals(bonusAmount(), other.bonusAmount())
                && Objects.equals(assignmentId(), other.assignmentId()) && Objects.equals(reason(), other.reason())
                && Objects.equals(grantTime(), other.grantTime());
    }

    @Override
    public String toString() {
        return ToString.builder("BonusPayment").add("WorkerId", workerId()).add("BonusAmount", bonusAmount())
                .add("AssignmentId", assignmentId()).add("Reason", reason()).add("GrantTime", grantTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "BonusAmount":
            return Optional.ofNullable(clazz.cast(bonusAmount()));
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "GrantTime":
            return Optional.ofNullable(clazz.cast(grantTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BonusPaymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BonusPayment> {
        /**
         * <p>
         * The ID of the Worker to whom the bonus was paid.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker to whom the bonus was paid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * Sets the value of the BonusAmount property for this object.
         *
         * @param bonusAmount
         *        The new value for the BonusAmount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bonusAmount(String bonusAmount);

        /**
         * <p>
         * The ID of the assignment associated with this bonus payment.
         * </p>
         * 
         * @param assignmentId
         *        The ID of the assignment associated with this bonus payment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * The Reason text given when the bonus was granted, if any.
         * </p>
         * 
         * @param reason
         *        The Reason text given when the bonus was granted, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The date and time of when the bonus was granted.
         * </p>
         * 
         * @param grantTime
         *        The date and time of when the bonus was granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTime(Instant grantTime);
    }

    static final class BuilderImpl implements Builder {
        private String workerId;

        private String bonusAmount;

        private String assignmentId;

        private String reason;

        private Instant grantTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BonusPayment model) {
            workerId(model.workerId);
            bonusAmount(model.bonusAmount);
            assignmentId(model.assignmentId);
            reason(model.reason);
            grantTime(model.grantTime);
        }

        public final String getWorkerId() {
            return workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getBonusAmount() {
            return bonusAmount;
        }

        @Override
        public final Builder bonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
            return this;
        }

        public final void setBonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getGrantTime() {
            return grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        @Override
        public BonusPayment build() {
            return new BonusPayment(this);
        }
    }
}
