/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAdditionalAssignmentsForHitRequest extends MTurkRequest implements
        ToCopyableBuilder<CreateAdditionalAssignmentsForHitRequest.Builder, CreateAdditionalAssignmentsForHitRequest> {
    private final String hitId;

    private final Integer numberOfAdditionalAssignments;

    private final String uniqueRequestToken;

    private CreateAdditionalAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.numberOfAdditionalAssignments = builder.numberOfAdditionalAssignments;
        this.uniqueRequestToken = builder.uniqueRequestToken;
    }

    /**
     * <p>
     * The ID of the HIT to extend.
     * </p>
     * 
     * @return The ID of the HIT to extend.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The number of additional assignments to request for this HIT.
     * </p>
     * 
     * @return The number of additional assignments to request for this HIT.
     */
    public Integer numberOfAdditionalAssignments() {
        return numberOfAdditionalAssignments;
    }

    /**
     * <p>
     * A unique identifier for this request, which allows you to retry the call on error without extending the HIT
     * multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call
     * succeeded on the server. If the extend HIT already exists in the system from a previous call using the same
     * <code>UniqueRequestToken</code>, subsequent calls will return an error with a message containing the request ID.
     * </p>
     * 
     * @return A unique identifier for this request, which allows you to retry the call on error without extending the
     *         HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether or not
     *         the call succeeded on the server. If the extend HIT already exists in the system from a previous call
     *         using the same <code>UniqueRequestToken</code>, subsequent calls will return an error with a message
     *         containing the request ID.
     */
    public String uniqueRequestToken() {
        return uniqueRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAdditionalAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdditionalAssignmentsForHitRequest)) {
            return false;
        }
        CreateAdditionalAssignmentsForHitRequest other = (CreateAdditionalAssignmentsForHitRequest) obj;
        return Objects.equals(hitId(), other.hitId())
                && Objects.equals(numberOfAdditionalAssignments(), other.numberOfAdditionalAssignments())
                && Objects.equals(uniqueRequestToken(), other.uniqueRequestToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateAdditionalAssignmentsForHitRequest").add("HITId", hitId())
                .add("NumberOfAdditionalAssignments", numberOfAdditionalAssignments())
                .add("UniqueRequestToken", uniqueRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "NumberOfAdditionalAssignments":
            return Optional.ofNullable(clazz.cast(numberOfAdditionalAssignments()));
        case "UniqueRequestToken":
            return Optional.ofNullable(clazz.cast(uniqueRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, CreateAdditionalAssignmentsForHitRequest> {
        /**
         * <p>
         * The ID of the HIT to extend.
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT to extend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The number of additional assignments to request for this HIT.
         * </p>
         * 
         * @param numberOfAdditionalAssignments
         *        The number of additional assignments to request for this HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAdditionalAssignments(Integer numberOfAdditionalAssignments);

        /**
         * <p>
         * A unique identifier for this request, which allows you to retry the call on error without extending the HIT
         * multiple times. This is useful in cases such as network timeouts where it is unclear whether or not the call
         * succeeded on the server. If the extend HIT already exists in the system from a previous call using the same
         * <code>UniqueRequestToken</code>, subsequent calls will return an error with a message containing the request
         * ID.
         * </p>
         * 
         * @param uniqueRequestToken
         *        A unique identifier for this request, which allows you to retry the call on error without extending
         *        the HIT multiple times. This is useful in cases such as network timeouts where it is unclear whether
         *        or not the call succeeded on the server. If the extend HIT already exists in the system from a
         *        previous call using the same <code>UniqueRequestToken</code>, subsequent calls will return an error
         *        with a message containing the request ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueRequestToken(String uniqueRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private Integer numberOfAdditionalAssignments;

        private String uniqueRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdditionalAssignmentsForHitRequest model) {
            super(model);
            hitId(model.hitId);
            numberOfAdditionalAssignments(model.numberOfAdditionalAssignments);
            uniqueRequestToken(model.uniqueRequestToken);
        }

        public final String getHITId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Integer getNumberOfAdditionalAssignments() {
            return numberOfAdditionalAssignments;
        }

        @Override
        public final Builder numberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
            return this;
        }

        public final void setNumberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
        }

        public final String getUniqueRequestToken() {
            return uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdditionalAssignmentsForHitRequest build() {
            return new CreateAdditionalAssignmentsForHitRequest(this);
        }
    }
}
