/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHitResponse extends MTurkResponse implements
        ToCopyableBuilder<CreateHitResponse.Builder, CreateHitResponse> {
    private final HIT hit;

    private CreateHitResponse(BuilderImpl builder) {
        super(builder);
        this.hit = builder.hit;
    }

    /**
     * <p>
     * Contains the newly created HIT data. For a description of the HIT data structure as it appears in responses, see
     * the HIT Data Structure documentation.
     * </p>
     * 
     * @return Contains the newly created HIT data. For a description of the HIT data structure as it appears in
     *         responses, see the HIT Data Structure documentation.
     */
    public HIT hit() {
        return hit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitResponse)) {
            return false;
        }
        CreateHitResponse other = (CreateHitResponse) obj;
        return Objects.equals(hit(), other.hit());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateHitResponse").add("HIT", hit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HIT":
            return Optional.ofNullable(clazz.cast(hit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkResponse.Builder, CopyableBuilder<Builder, CreateHitResponse> {
        /**
         * <p>
         * Contains the newly created HIT data. For a description of the HIT data structure as it appears in responses,
         * see the HIT Data Structure documentation.
         * </p>
         * 
         * @param hit
         *        Contains the newly created HIT data. For a description of the HIT data structure as it appears in
         *        responses, see the HIT Data Structure documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(HIT hit);

        /**
         * <p>
         * Contains the newly created HIT data. For a description of the HIT data structure as it appears in responses,
         * see the HIT Data Structure documentation.
         * </p>
         * This is a convenience that creates an instance of the {@link HIT.Builder} avoiding the need to create one
         * manually via {@link HIT#builder()}.
         *
         * When the {@link Consumer} completes, {@link HIT.Builder#build()} is called immediately and its result is
         * passed to {@link #hit(HIT)}.
         * 
         * @param hit
         *        a consumer that will call methods on {@link HIT.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hit(HIT)
         */
        default Builder hit(Consumer<HIT.Builder> hit) {
            return hit(HIT.builder().applyMutation(hit).build());
        }
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private HIT hit;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitResponse model) {
            super(model);
            hit(model.hit);
        }

        public final HIT.Builder getHIT() {
            return hit != null ? hit.toBuilder() : null;
        }

        @Override
        public final Builder hit(HIT hit) {
            this.hit = hit;
            return this;
        }

        public final void setHIT(HIT.BuilderImpl hit) {
            this.hit = hit != null ? hit.build() : null;
        }

        @Override
        public CreateHitResponse build() {
            return new CreateHitResponse(this);
        }
    }
}
