/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHitTypeResponse extends MTurkResponse implements
        ToCopyableBuilder<CreateHitTypeResponse.Builder, CreateHitTypeResponse> {
    private final String hitTypeId;

    private CreateHitTypeResponse(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
    }

    /**
     * <p>
     * The ID of the newly registered HIT type.
     * </p>
     * 
     * @return The ID of the newly registered HIT type.
     */
    public String hitTypeId() {
        return hitTypeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitTypeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitTypeResponse)) {
            return false;
        }
        CreateHitTypeResponse other = (CreateHitTypeResponse) obj;
        return Objects.equals(hitTypeId(), other.hitTypeId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateHitTypeResponse").add("HITTypeId", hitTypeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITTypeId":
            return Optional.ofNullable(clazz.cast(hitTypeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkResponse.Builder, CopyableBuilder<Builder, CreateHitTypeResponse> {
        /**
         * <p>
         * The ID of the newly registered HIT type.
         * </p>
         * 
         * @param hitTypeId
         *        The ID of the newly registered HIT type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitTypeId(String hitTypeId);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String hitTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitTypeResponse model) {
            super(model);
            hitTypeId(model.hitTypeId);
        }

        public final String getHITTypeId() {
            return hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        @Override
        public CreateHitTypeResponse build() {
            return new CreateHitTypeResponse(this);
        }
    }
}
