/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQualificationTypeResponse extends MTurkResponse implements
        ToCopyableBuilder<CreateQualificationTypeResponse.Builder, CreateQualificationTypeResponse> {
    private final QualificationType qualificationType;

    private CreateQualificationTypeResponse(BuilderImpl builder) {
        super(builder);
        this.qualificationType = builder.qualificationType;
    }

    /**
     * <p>
     * The created Qualification type, returned as a QualificationType data structure.
     * </p>
     * 
     * @return The created Qualification type, returned as a QualificationType data structure.
     */
    public QualificationType qualificationType() {
        return qualificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qualificationType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQualificationTypeResponse)) {
            return false;
        }
        CreateQualificationTypeResponse other = (CreateQualificationTypeResponse) obj;
        return Objects.equals(qualificationType(), other.qualificationType());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateQualificationTypeResponse").add("QualificationType", qualificationType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationType":
            return Optional.ofNullable(clazz.cast(qualificationType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkResponse.Builder, CopyableBuilder<Builder, CreateQualificationTypeResponse> {
        /**
         * <p>
         * The created Qualification type, returned as a QualificationType data structure.
         * </p>
         * 
         * @param qualificationType
         *        The created Qualification type, returned as a QualificationType data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationType(QualificationType qualificationType);

        /**
         * <p>
         * The created Qualification type, returned as a QualificationType data structure.
         * </p>
         * This is a convenience that creates an instance of the {@link QualificationType.Builder} avoiding the need to
         * create one manually via {@link QualificationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link QualificationType.Builder#build()} is called immediately and its
         * result is passed to {@link #qualificationType(QualificationType)}.
         * 
         * @param qualificationType
         *        a consumer that will call methods on {@link QualificationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationType(QualificationType)
         */
        default Builder qualificationType(Consumer<QualificationType.Builder> qualificationType) {
            return qualificationType(QualificationType.builder().applyMutation(qualificationType).build());
        }
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private QualificationType qualificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQualificationTypeResponse model) {
            super(model);
            qualificationType(model.qualificationType);
        }

        public final QualificationType.Builder getQualificationType() {
            return qualificationType != null ? qualificationType.toBuilder() : null;
        }

        @Override
        public final Builder qualificationType(QualificationType qualificationType) {
            this.qualificationType = qualificationType;
            return this;
        }

        public final void setQualificationType(QualificationType.BuilderImpl qualificationType) {
            this.qualificationType = qualificationType != null ? qualificationType.build() : null;
        }

        @Override
        public CreateQualificationTypeResponse build() {
            return new CreateQualificationTypeResponse(this);
        }
    }
}
