/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateQualificationFromWorkerRequest extends MTurkRequest implements
        ToCopyableBuilder<DisassociateQualificationFromWorkerRequest.Builder, DisassociateQualificationFromWorkerRequest> {
    private final String workerId;

    private final String qualificationTypeId;

    private final String reason;

    private DisassociateQualificationFromWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.workerId = builder.workerId;
        this.qualificationTypeId = builder.qualificationTypeId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The ID of the Worker who possesses the Qualification to be revoked.
     * </p>
     * 
     * @return The ID of the Worker who possesses the Qualification to be revoked.
     */
    public String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The ID of the Qualification type of the Qualification to be revoked.
     * </p>
     * 
     * @return The ID of the Qualification type of the Qualification to be revoked.
     */
    public String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * A text message that explains why the Qualification was revoked. The user who had the Qualification sees this
     * message.
     * </p>
     * 
     * @return A text message that explains why the Qualification was revoked. The user who had the Qualification sees
     *         this message.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateQualificationFromWorkerRequest)) {
            return false;
        }
        DisassociateQualificationFromWorkerRequest other = (DisassociateQualificationFromWorkerRequest) obj;
        return Objects.equals(workerId(), other.workerId()) && Objects.equals(qualificationTypeId(), other.qualificationTypeId())
                && Objects.equals(reason(), other.reason());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateQualificationFromWorkerRequest").add("WorkerId", workerId())
                .add("QualificationTypeId", qualificationTypeId()).add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, DisassociateQualificationFromWorkerRequest> {
        /**
         * <p>
         * The ID of the Worker who possesses the Qualification to be revoked.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker who possesses the Qualification to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The ID of the Qualification type of the Qualification to be revoked.
         * </p>
         * 
         * @param qualificationTypeId
         *        The ID of the Qualification type of the Qualification to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * A text message that explains why the Qualification was revoked. The user who had the Qualification sees this
         * message.
         * </p>
         * 
         * @param reason
         *        A text message that explains why the Qualification was revoked. The user who had the Qualification
         *        sees this message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String workerId;

        private String qualificationTypeId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateQualificationFromWorkerRequest model) {
            super(model);
            workerId(model.workerId);
            qualificationTypeId(model.qualificationTypeId);
            reason(model.reason);
        }

        public final String getWorkerId() {
            return workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateQualificationFromWorkerRequest build() {
            return new DisassociateQualificationFromWorkerRequest(this);
        }
    }
}
