/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFileUploadUrlRequest extends MTurkRequest implements
        ToCopyableBuilder<GetFileUploadUrlRequest.Builder, GetFileUploadUrlRequest> {
    private final String assignmentId;

    private final String questionIdentifier;

    private GetFileUploadUrlRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentId = builder.assignmentId;
        this.questionIdentifier = builder.questionIdentifier;
    }

    /**
     * <p>
     * The ID of the assignment that contains the question with a FileUploadAnswer.
     * </p>
     * 
     * @return The ID of the assignment that contains the question with a FileUploadAnswer.
     */
    public String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.
     * </p>
     * 
     * @return The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.
     */
    public String questionIdentifier() {
        return questionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(questionIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileUploadUrlRequest)) {
            return false;
        }
        GetFileUploadUrlRequest other = (GetFileUploadUrlRequest) obj;
        return Objects.equals(assignmentId(), other.assignmentId())
                && Objects.equals(questionIdentifier(), other.questionIdentifier());
    }

    @Override
    public String toString() {
        return ToString.builder("GetFileUploadUrlRequest").add("AssignmentId", assignmentId())
                .add("QuestionIdentifier", questionIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "QuestionIdentifier":
            return Optional.ofNullable(clazz.cast(questionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, GetFileUploadUrlRequest> {
        /**
         * <p>
         * The ID of the assignment that contains the question with a FileUploadAnswer.
         * </p>
         * 
         * @param assignmentId
         *        The ID of the assignment that contains the question with a FileUploadAnswer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.
         * </p>
         * 
         * @param questionIdentifier
         *        The identifier of the question with a FileUploadAnswer, as specified in the QuestionForm of the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionIdentifier(String questionIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String assignmentId;

        private String questionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileUploadUrlRequest model) {
            super(model);
            assignmentId(model.assignmentId);
            questionIdentifier(model.questionIdentifier);
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getQuestionIdentifier() {
            return questionIdentifier;
        }

        @Override
        public final Builder questionIdentifier(String questionIdentifier) {
            this.questionIdentifier = questionIdentifier;
            return this;
        }

        public final void setQuestionIdentifier(String questionIdentifier) {
            this.questionIdentifier = questionIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFileUploadUrlRequest build() {
            return new GetFileUploadUrlRequest(this);
        }
    }
}
