/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFileUploadUrlResponse extends MTurkResponse implements
        ToCopyableBuilder<GetFileUploadUrlResponse.Builder, GetFileUploadUrlResponse> {
    private final String fileUploadURL;

    private GetFileUploadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.fileUploadURL = builder.fileUploadURL;
    }

    /**
     * <p>
     * A temporary URL for the file that the Worker uploaded for the answer.
     * </p>
     * 
     * @return A temporary URL for the file that the Worker uploaded for the answer.
     */
    public String fileUploadURL() {
        return fileUploadURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileUploadURL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileUploadUrlResponse)) {
            return false;
        }
        GetFileUploadUrlResponse other = (GetFileUploadUrlResponse) obj;
        return Objects.equals(fileUploadURL(), other.fileUploadURL());
    }

    @Override
    public String toString() {
        return ToString.builder("GetFileUploadUrlResponse").add("FileUploadURL", fileUploadURL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileUploadURL":
            return Optional.ofNullable(clazz.cast(fileUploadURL()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkResponse.Builder, CopyableBuilder<Builder, GetFileUploadUrlResponse> {
        /**
         * <p>
         * A temporary URL for the file that the Worker uploaded for the answer.
         * </p>
         * 
         * @param fileUploadURL
         *        A temporary URL for the file that the Worker uploaded for the answer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileUploadURL(String fileUploadURL);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String fileUploadURL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileUploadUrlResponse model) {
            super(model);
            fileUploadURL(model.fileUploadURL);
        }

        public final String getFileUploadURL() {
            return fileUploadURL;
        }

        @Override
        public final Builder fileUploadURL(String fileUploadURL) {
            this.fileUploadURL = fileUploadURL;
            return this;
        }

        public final void setFileUploadURL(String fileUploadURL) {
            this.fileUploadURL = fileUploadURL;
        }

        @Override
        public GetFileUploadUrlResponse build() {
            return new GetFileUploadUrlResponse(this);
        }
    }
}
