/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.HITLayoutParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The HITLayoutParameter data structure defines parameter values used with a HITLayout. A HITLayout is a reusable
 * Amazon Mechanical Turk project template used to provide Human Intelligence Task (HIT) question data for CreateHIT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HITLayoutParameter implements StructuredPojo,
        ToCopyableBuilder<HITLayoutParameter.Builder, HITLayoutParameter> {
    private final String name;

    private final String value;

    private HITLayoutParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the parameter in the HITLayout.
     * </p>
     * 
     * @return The name of the parameter in the HITLayout.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value substituted for the parameter referenced in the HITLayout.
     * </p>
     * 
     * @return The value substituted for the parameter referenced in the HITLayout.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HITLayoutParameter)) {
            return false;
        }
        HITLayoutParameter other = (HITLayoutParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("HITLayoutParameter").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HITLayoutParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HITLayoutParameter> {
        /**
         * <p>
         * The name of the parameter in the HITLayout.
         * </p>
         * 
         * @param name
         *        The name of the parameter in the HITLayout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value substituted for the parameter referenced in the HITLayout.
         * </p>
         * 
         * @param value
         *        The value substituted for the parameter referenced in the HITLayout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(HITLayoutParameter model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public HITLayoutParameter build() {
            return new HITLayoutParameter(this);
        }
    }
}
