/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssignmentsForHitRequest extends MTurkRequest implements
        ToCopyableBuilder<ListAssignmentsForHitRequest.Builder, ListAssignmentsForHitRequest> {
    private final String hitId;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> assignmentStatuses;

    private ListAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assignmentStatuses = builder.assignmentStatuses;
    }

    /**
     * <p>
     * The ID of the HIT.
     * </p>
     * 
     * @return The ID of the HIT.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * Pagination token
     * </p>
     * 
     * @return Pagination token
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The status of the assignments to return: Submitted | Approved | Rejected
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The status of the assignments to return: Submitted | Approved | Rejected
     */
    public List<AssignmentStatus> assignmentStatuses() {
        return TypeConverter.convert(assignmentStatuses, AssignmentStatus::fromValue);
    }

    /**
     * <p>
     * The status of the assignments to return: Submitted | Approved | Rejected
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The status of the assignments to return: Submitted | Approved | Rejected
     */
    public List<String> assignmentStatusesAsStrings() {
        return assignmentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssignmentsForHitRequest)) {
            return false;
        }
        ListAssignmentsForHitRequest other = (ListAssignmentsForHitRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(assignmentStatusesAsStrings(), other.assignmentStatusesAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAssignmentsForHitRequest").add("HITId", hitId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("AssignmentStatuses", assignmentStatusesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "AssignmentStatuses":
            return Optional.ofNullable(clazz.cast(assignmentStatusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, ListAssignmentsForHitRequest> {
        /**
         * <p>
         * The ID of the HIT.
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * Pagination token
         * </p>
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatusesWithStrings(Collection<String> assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatusesWithStrings(String... assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatuses(Collection<AssignmentStatus> assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatuses(AssignmentStatus... assignmentStatuses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private String nextToken;

        private Integer maxResults;

        private List<String> assignmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssignmentsForHitRequest model) {
            super(model);
            hitId(model.hitId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            assignmentStatusesWithStrings(model.assignmentStatuses);
        }

        public final String getHITId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getAssignmentStatuses() {
            return assignmentStatuses;
        }

        @Override
        public final Builder assignmentStatusesWithStrings(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignmentStatusesWithStrings(String... assignmentStatuses) {
            assignmentStatusesWithStrings(Arrays.asList(assignmentStatuses));
            return this;
        }

        @Override
        public final Builder assignmentStatuses(Collection<AssignmentStatus> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copyEnumToString(assignmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignmentStatuses(AssignmentStatus... assignmentStatuses) {
            assignmentStatuses(Arrays.asList(assignmentStatuses));
            return this;
        }

        public final void setAssignmentStatuses(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssignmentsForHitRequest build() {
            return new ListAssignmentsForHitRequest(this);
        }
    }
}
