/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReviewPolicyResultsForHitRequest extends MTurkRequest implements
        ToCopyableBuilder<ListReviewPolicyResultsForHitRequest.Builder, ListReviewPolicyResultsForHitRequest> {
    private final String hitId;

    private final List<String> policyLevels;

    private final Boolean retrieveActions;

    private final Boolean retrieveResults;

    private final String nextToken;

    private final Integer maxResults;

    private ListReviewPolicyResultsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.policyLevels = builder.policyLevels;
        this.retrieveActions = builder.retrieveActions;
        this.retrieveResults = builder.retrieveResults;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier of the HIT to retrieve review results for.
     * </p>
     * 
     * @return The unique identifier of the HIT to retrieve review results for.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to
     * retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior
     *         is to retrieve all data for both policy levels. For a list of all the described policies, see Review
     *         Policies.
     */
    public List<ReviewPolicyLevel> policyLevels() {
        return TypeConverter.convert(policyLevels, ReviewPolicyLevel::fromValue);
    }

    /**
     * <p>
     * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is to
     * retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior
     *         is to retrieve all data for both policy levels. For a list of all the described policies, see Review
     *         Policies.
     */
    public List<String> policyLevelsAsStrings() {
        return policyLevels;
    }

    /**
     * <p>
     * Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their
     * outcomes.
     * </p>
     * 
     * @return Specify if the operation should retrieve a list of the actions taken executing the Review Policies and
     *         their outcomes.
     */
    public Boolean retrieveActions() {
        return retrieveActions;
    }

    /**
     * <p>
     * Specify if the operation should retrieve a list of the results computed by the Review Policies.
     * </p>
     * 
     * @return Specify if the operation should retrieve a list of the results computed by the Review Policies.
     */
    public Boolean retrieveResults() {
        return retrieveResults;
    }

    /**
     * <p>
     * Pagination token
     * </p>
     * 
     * @return Pagination token
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Limit the number of results returned.
     * </p>
     * 
     * @return Limit the number of results returned.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(policyLevelsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveActions());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewPolicyResultsForHitRequest)) {
            return false;
        }
        ListReviewPolicyResultsForHitRequest other = (ListReviewPolicyResultsForHitRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(policyLevelsAsStrings(), other.policyLevelsAsStrings())
                && Objects.equals(retrieveActions(), other.retrieveActions())
                && Objects.equals(retrieveResults(), other.retrieveResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListReviewPolicyResultsForHitRequest").add("HITId", hitId())
                .add("PolicyLevels", policyLevelsAsStrings()).add("RetrieveActions", retrieveActions())
                .add("RetrieveResults", retrieveResults()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "PolicyLevels":
            return Optional.ofNullable(clazz.cast(policyLevelsAsStrings()));
        case "RetrieveActions":
            return Optional.ofNullable(clazz.cast(retrieveActions()));
        case "RetrieveResults":
            return Optional.ofNullable(clazz.cast(retrieveResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, ListReviewPolicyResultsForHitRequest> {
        /**
         * <p>
         * The unique identifier of the HIT to retrieve review results for.
         * </p>
         * 
         * @param hitId
         *        The unique identifier of the HIT to retrieve review results for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is
         * to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
         * </p>
         * 
         * @param policyLevels
         *        The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default
         *        behavior is to retrieve all data for both policy levels. For a list of all the described policies, see
         *        Review Policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyLevelsWithStrings(Collection<String> policyLevels);

        /**
         * <p>
         * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is
         * to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
         * </p>
         * 
         * @param policyLevels
         *        The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default
         *        behavior is to retrieve all data for both policy levels. For a list of all the described policies, see
         *        Review Policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyLevelsWithStrings(String... policyLevels);

        /**
         * <p>
         * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is
         * to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
         * </p>
         * 
         * @param policyLevels
         *        The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default
         *        behavior is to retrieve all data for both policy levels. For a list of all the described policies, see
         *        Review Policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyLevels(Collection<ReviewPolicyLevel> policyLevels);

        /**
         * <p>
         * The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default behavior is
         * to retrieve all data for both policy levels. For a list of all the described policies, see Review Policies.
         * </p>
         * 
         * @param policyLevels
         *        The Policy Level(s) to retrieve review results for - HIT or Assignment. If omitted, the default
         *        behavior is to retrieve all data for both policy levels. For a list of all the described policies, see
         *        Review Policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyLevels(ReviewPolicyLevel... policyLevels);

        /**
         * <p>
         * Specify if the operation should retrieve a list of the actions taken executing the Review Policies and their
         * outcomes.
         * </p>
         * 
         * @param retrieveActions
         *        Specify if the operation should retrieve a list of the actions taken executing the Review Policies and
         *        their outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveActions(Boolean retrieveActions);

        /**
         * <p>
         * Specify if the operation should retrieve a list of the results computed by the Review Policies.
         * </p>
         * 
         * @param retrieveResults
         *        Specify if the operation should retrieve a list of the results computed by the Review Policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveResults(Boolean retrieveResults);

        /**
         * <p>
         * Pagination token
         * </p>
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Limit the number of results returned.
         * </p>
         * 
         * @param maxResults
         *        Limit the number of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private List<String> policyLevels = DefaultSdkAutoConstructList.getInstance();

        private Boolean retrieveActions;

        private Boolean retrieveResults;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewPolicyResultsForHitRequest model) {
            super(model);
            hitId(model.hitId);
            policyLevelsWithStrings(model.policyLevels);
            retrieveActions(model.retrieveActions);
            retrieveResults(model.retrieveResults);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getHITId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Collection<String> getPolicyLevels() {
            return policyLevels;
        }

        @Override
        public final Builder policyLevelsWithStrings(Collection<String> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copy(policyLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyLevelsWithStrings(String... policyLevels) {
            policyLevelsWithStrings(Arrays.asList(policyLevels));
            return this;
        }

        @Override
        public final Builder policyLevels(Collection<ReviewPolicyLevel> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copyEnumToString(policyLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyLevels(ReviewPolicyLevel... policyLevels) {
            policyLevels(Arrays.asList(policyLevels));
            return this;
        }

        public final void setPolicyLevels(Collection<String> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copy(policyLevels);
        }

        public final Boolean getRetrieveActions() {
            return retrieveActions;
        }

        @Override
        public final Builder retrieveActions(Boolean retrieveActions) {
            this.retrieveActions = retrieveActions;
            return this;
        }

        public final void setRetrieveActions(Boolean retrieveActions) {
            this.retrieveActions = retrieveActions;
        }

        public final Boolean getRetrieveResults() {
            return retrieveResults;
        }

        @Override
        public final Builder retrieveResults(Boolean retrieveResults) {
            this.retrieveResults = retrieveResults;
            return this;
        }

        public final void setRetrieveResults(Boolean retrieveResults) {
            this.retrieveResults = retrieveResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReviewPolicyResultsForHitRequest build() {
            return new ListReviewPolicyResultsForHitRequest(this);
        }
    }
}
