/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReviewableHiTsRequest extends MTurkRequest implements
        ToCopyableBuilder<ListReviewableHiTsRequest.Builder, ListReviewableHiTsRequest> {
    private final String hitTypeId;

    private final String status;

    private final String nextToken;

    private final Integer maxResults;

    private ListReviewableHiTsRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are
     * considered
     * </p>
     * 
     * @return The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer
     *         are considered
     */
    public String hitTypeId() {
        return hitTypeId;
    }

    /**
     * <p>
     * Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewableHITStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
     * @see ReviewableHITStatus
     */
    public ReviewableHITStatus status() {
        return ReviewableHITStatus.fromValue(status);
    }

    /**
     * <p>
     * Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewableHITStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
     * @see ReviewableHITStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Pagination Token
     * </p>
     * 
     * @return Pagination Token
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Limit the number of results returned.
     * </p>
     * 
     * @return Limit the number of results returned.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewableHiTsRequest)) {
            return false;
        }
        ListReviewableHiTsRequest other = (ListReviewableHiTsRequest) obj;
        return Objects.equals(hitTypeId(), other.hitTypeId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListReviewableHiTsRequest").add("HITTypeId", hitTypeId()).add("Status", statusAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITTypeId":
            return Optional.ofNullable(clazz.cast(hitTypeId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, ListReviewableHiTsRequest> {
        /**
         * <p>
         * The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the Reviewer are
         * considered
         * </p>
         * 
         * @param hitTypeId
         *        The ID of the HIT type of the HITs to consider for the query. If not specified, all HITs for the
         *        Reviewer are considered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitTypeId(String hitTypeId);

        /**
         * <p>
         * Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
         * </p>
         * 
         * @param status
         *        Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
         * @see ReviewableHITStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewableHITStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
         * </p>
         * 
         * @param status
         *        Can be either <code>Reviewable</code> or <code>Reviewing</code>. Reviewable is the default value.
         * @see ReviewableHITStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewableHITStatus
         */
        Builder status(ReviewableHITStatus status);

        /**
         * <p>
         * Pagination Token
         * </p>
         * 
         * @param nextToken
         *        Pagination Token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Limit the number of results returned.
         * </p>
         * 
         * @param maxResults
         *        Limit the number of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitTypeId;

        private String status;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewableHiTsRequest model) {
            super(model);
            hitTypeId(model.hitTypeId);
            status(model.status);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getHITTypeId() {
            return hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewableHITStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReviewableHiTsRequest build() {
            return new ListReviewableHiTsRequest(this);
        }
    }
}
