/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersFailureStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When MTurk encounters an issue with notifying the Workers you specified, it returns back this object with failure
 * details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyWorkersFailureStatus implements StructuredPojo,
        ToCopyableBuilder<NotifyWorkersFailureStatus.Builder, NotifyWorkersFailureStatus> {
    private final String notifyWorkersFailureCode;

    private final String notifyWorkersFailureMessage;

    private final String workerId;

    private NotifyWorkersFailureStatus(BuilderImpl builder) {
        this.notifyWorkersFailureCode = builder.notifyWorkersFailureCode;
        this.notifyWorkersFailureMessage = builder.notifyWorkersFailureMessage;
        this.workerId = builder.workerId;
    }

    /**
     * <p>
     * Encoded value for the failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notifyWorkersFailureCode} will return {@link NotifyWorkersFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #notifyWorkersFailureCodeAsString}.
     * </p>
     * 
     * @return Encoded value for the failure type.
     * @see NotifyWorkersFailureCode
     */
    public NotifyWorkersFailureCode notifyWorkersFailureCode() {
        return NotifyWorkersFailureCode.fromValue(notifyWorkersFailureCode);
    }

    /**
     * <p>
     * Encoded value for the failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notifyWorkersFailureCode} will return {@link NotifyWorkersFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #notifyWorkersFailureCodeAsString}.
     * </p>
     * 
     * @return Encoded value for the failure type.
     * @see NotifyWorkersFailureCode
     */
    public String notifyWorkersFailureCodeAsString() {
        return notifyWorkersFailureCode;
    }

    /**
     * <p>
     * A message detailing the reason the Worker could not be notified.
     * </p>
     * 
     * @return A message detailing the reason the Worker could not be notified.
     */
    public String notifyWorkersFailureMessage() {
        return notifyWorkersFailureMessage;
    }

    /**
     * <p>
     * The ID of the Worker.
     * </p>
     * 
     * @return The ID of the Worker.
     */
    public String workerId() {
        return workerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notifyWorkersFailureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notifyWorkersFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersFailureStatus)) {
            return false;
        }
        NotifyWorkersFailureStatus other = (NotifyWorkersFailureStatus) obj;
        return Objects.equals(notifyWorkersFailureCodeAsString(), other.notifyWorkersFailureCodeAsString())
                && Objects.equals(notifyWorkersFailureMessage(), other.notifyWorkersFailureMessage())
                && Objects.equals(workerId(), other.workerId());
    }

    @Override
    public String toString() {
        return ToString.builder("NotifyWorkersFailureStatus").add("NotifyWorkersFailureCode", notifyWorkersFailureCodeAsString())
                .add("NotifyWorkersFailureMessage", notifyWorkersFailureMessage()).add("WorkerId", workerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotifyWorkersFailureCode":
            return Optional.ofNullable(clazz.cast(notifyWorkersFailureCodeAsString()));
        case "NotifyWorkersFailureMessage":
            return Optional.ofNullable(clazz.cast(notifyWorkersFailureMessage()));
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotifyWorkersFailureStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NotifyWorkersFailureStatus> {
        /**
         * <p>
         * Encoded value for the failure type.
         * </p>
         * 
         * @param notifyWorkersFailureCode
         *        Encoded value for the failure type.
         * @see NotifyWorkersFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotifyWorkersFailureCode
         */
        Builder notifyWorkersFailureCode(String notifyWorkersFailureCode);

        /**
         * <p>
         * Encoded value for the failure type.
         * </p>
         * 
         * @param notifyWorkersFailureCode
         *        Encoded value for the failure type.
         * @see NotifyWorkersFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotifyWorkersFailureCode
         */
        Builder notifyWorkersFailureCode(NotifyWorkersFailureCode notifyWorkersFailureCode);

        /**
         * <p>
         * A message detailing the reason the Worker could not be notified.
         * </p>
         * 
         * @param notifyWorkersFailureMessage
         *        A message detailing the reason the Worker could not be notified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyWorkersFailureMessage(String notifyWorkersFailureMessage);

        /**
         * <p>
         * The ID of the Worker.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);
    }

    static final class BuilderImpl implements Builder {
        private String notifyWorkersFailureCode;

        private String notifyWorkersFailureMessage;

        private String workerId;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyWorkersFailureStatus model) {
            notifyWorkersFailureCode(model.notifyWorkersFailureCode);
            notifyWorkersFailureMessage(model.notifyWorkersFailureMessage);
            workerId(model.workerId);
        }

        public final String getNotifyWorkersFailureCode() {
            return notifyWorkersFailureCode;
        }

        @Override
        public final Builder notifyWorkersFailureCode(String notifyWorkersFailureCode) {
            this.notifyWorkersFailureCode = notifyWorkersFailureCode;
            return this;
        }

        @Override
        public final Builder notifyWorkersFailureCode(NotifyWorkersFailureCode notifyWorkersFailureCode) {
            this.notifyWorkersFailureCode(notifyWorkersFailureCode.toString());
            return this;
        }

        public final void setNotifyWorkersFailureCode(String notifyWorkersFailureCode) {
            this.notifyWorkersFailureCode = notifyWorkersFailureCode;
        }

        public final String getNotifyWorkersFailureMessage() {
            return notifyWorkersFailureMessage;
        }

        @Override
        public final Builder notifyWorkersFailureMessage(String notifyWorkersFailureMessage) {
            this.notifyWorkersFailureMessage = notifyWorkersFailureMessage;
            return this;
        }

        public final void setNotifyWorkersFailureMessage(String notifyWorkersFailureMessage) {
            this.notifyWorkersFailureMessage = notifyWorkersFailureMessage;
        }

        public final String getWorkerId() {
            return workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public NotifyWorkersFailureStatus build() {
            return new NotifyWorkersFailureStatus(this);
        }
    }
}
