/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyWorkersResponse extends MTurkResponse implements
        ToCopyableBuilder<NotifyWorkersResponse.Builder, NotifyWorkersResponse> {
    private final List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses;

    private NotifyWorkersResponse(BuilderImpl builder) {
        super(builder);
        this.notifyWorkersFailureStatuses = builder.notifyWorkersFailureStatuses;
    }

    /**
     * <p>
     * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this list of
     * NotifyWorkersFailureStatus objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
     *         list of NotifyWorkersFailureStatus objects.
     */
    public List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses() {
        return notifyWorkersFailureStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notifyWorkersFailureStatuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersResponse)) {
            return false;
        }
        NotifyWorkersResponse other = (NotifyWorkersResponse) obj;
        return Objects.equals(notifyWorkersFailureStatuses(), other.notifyWorkersFailureStatuses());
    }

    @Override
    public String toString() {
        return ToString.builder("NotifyWorkersResponse").add("NotifyWorkersFailureStatuses", notifyWorkersFailureStatuses())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotifyWorkersFailureStatuses":
            return Optional.ofNullable(clazz.cast(notifyWorkersFailureStatuses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkResponse.Builder, CopyableBuilder<Builder, NotifyWorkersResponse> {
        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * 
         * @param notifyWorkersFailureStatuses
         *        When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in
         *        this list of NotifyWorkersFailureStatus objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyWorkersFailureStatuses(Collection<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses);

        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * 
         * @param notifyWorkersFailureStatuses
         *        When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in
         *        this list of NotifyWorkersFailureStatus objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyWorkersFailureStatuses(NotifyWorkersFailureStatus... notifyWorkersFailureStatuses);

        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotifyWorkersFailureStatus>.Builder}
         * avoiding the need to create one manually via {@link List<NotifyWorkersFailureStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotifyWorkersFailureStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #notifyWorkersFailureStatuses(List<NotifyWorkersFailureStatus>)}.
         * 
         * @param notifyWorkersFailureStatuses
         *        a consumer that will call methods on {@link List<NotifyWorkersFailureStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifyWorkersFailureStatuses(List<NotifyWorkersFailureStatus>)
         */
        Builder notifyWorkersFailureStatuses(Consumer<NotifyWorkersFailureStatus.Builder>... notifyWorkersFailureStatuses);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyWorkersResponse model) {
            super(model);
            notifyWorkersFailureStatuses(model.notifyWorkersFailureStatuses);
        }

        public final Collection<NotifyWorkersFailureStatus.Builder> getNotifyWorkersFailureStatuses() {
            return notifyWorkersFailureStatuses != null ? notifyWorkersFailureStatuses.stream()
                    .map(NotifyWorkersFailureStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notifyWorkersFailureStatuses(Collection<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses) {
            this.notifyWorkersFailureStatuses = NotifyWorkersFailureStatusListCopier.copy(notifyWorkersFailureStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifyWorkersFailureStatuses(NotifyWorkersFailureStatus... notifyWorkersFailureStatuses) {
            notifyWorkersFailureStatuses(Arrays.asList(notifyWorkersFailureStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifyWorkersFailureStatuses(
                Consumer<NotifyWorkersFailureStatus.Builder>... notifyWorkersFailureStatuses) {
            notifyWorkersFailureStatuses(Stream.of(notifyWorkersFailureStatuses)
                    .map(c -> NotifyWorkersFailureStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotifyWorkersFailureStatuses(
                Collection<NotifyWorkersFailureStatus.BuilderImpl> notifyWorkersFailureStatuses) {
            this.notifyWorkersFailureStatuses = NotifyWorkersFailureStatusListCopier
                    .copyFromBuilder(notifyWorkersFailureStatuses);
        }

        @Override
        public NotifyWorkersResponse build() {
            return new NotifyWorkersResponse(this);
        }
    }
}
