/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.transform.PolicyParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Name of the parameter from the Review policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyParameter implements StructuredPojo, ToCopyableBuilder<PolicyParameter.Builder, PolicyParameter> {
    private final String key;

    private final List<String> values;

    private final List<ParameterMapEntry> mapEntries;

    private PolicyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.mapEntries = builder.mapEntries;
    }

    /**
     * <p>
     * Name of the parameter from the list of Review Polices.
     * </p>
     * 
     * @return Name of the parameter from the list of Review Polices.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The list of values of the Parameter
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of values of the Parameter
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * List of ParameterMapEntry objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of ParameterMapEntry objects.
     */
    public List<ParameterMapEntry> mapEntries() {
        return mapEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(mapEntries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyParameter)) {
            return false;
        }
        PolicyParameter other = (PolicyParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values())
                && Objects.equals(mapEntries(), other.mapEntries());
    }

    @Override
    public String toString() {
        return ToString.builder("PolicyParameter").add("Key", key()).add("Values", values()).add("MapEntries", mapEntries())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "MapEntries":
            return Optional.ofNullable(clazz.cast(mapEntries()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PolicyParameter> {
        /**
         * <p>
         * Name of the parameter from the list of Review Polices.
         * </p>
         * 
         * @param key
         *        Name of the parameter from the list of Review Polices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The list of values of the Parameter
         * </p>
         * 
         * @param values
         *        The list of values of the Parameter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The list of values of the Parameter
         * </p>
         * 
         * @param values
         *        The list of values of the Parameter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * 
         * @param mapEntries
         *        List of ParameterMapEntry objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEntries(Collection<ParameterMapEntry> mapEntries);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * 
         * @param mapEntries
         *        List of ParameterMapEntry objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEntries(ParameterMapEntry... mapEntries);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterMapEntry>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterMapEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterMapEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #mapEntries(List<ParameterMapEntry>)}.
         * 
         * @param mapEntries
         *        a consumer that will call methods on {@link List<ParameterMapEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapEntries(List<ParameterMapEntry>)
         */
        Builder mapEntries(Consumer<ParameterMapEntry.Builder>... mapEntries);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterMapEntry> mapEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyParameter model) {
            key(model.key);
            values(model.values);
            mapEntries(model.mapEntries);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        public final Collection<ParameterMapEntry.Builder> getMapEntries() {
            return mapEntries != null ? mapEntries.stream().map(ParameterMapEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapEntries(Collection<ParameterMapEntry> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copy(mapEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(ParameterMapEntry... mapEntries) {
            mapEntries(Arrays.asList(mapEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(Consumer<ParameterMapEntry.Builder>... mapEntries) {
            mapEntries(Stream.of(mapEntries).map(c -> ParameterMapEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMapEntries(Collection<ParameterMapEntry.BuilderImpl> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copyFromBuilder(mapEntries);
        }

        @Override
        public PolicyParameter build() {
            return new PolicyParameter(this);
        }
    }
}
