/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.ReviewActionDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Both the AssignmentReviewReport and the HITReviewReport elements contains the ReviewActionDetail data structure. This
 * structure is returned multiple times for each action specified in the Review Policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewActionDetail implements StructuredPojo,
        ToCopyableBuilder<ReviewActionDetail.Builder, ReviewActionDetail> {
    private final String actionId;

    private final String actionName;

    private final String targetId;

    private final String targetType;

    private final String status;

    private final Instant completeTime;

    private final String result;

    private final String errorCode;

    private ReviewActionDetail(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionName = builder.actionName;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.status = builder.status;
        this.completeTime = builder.completeTime;
        this.result = builder.result;
        this.errorCode = builder.errorCode;
    }

    /**
     * <p>
     * The unique identifier for the action.
     * </p>
     * 
     * @return The unique identifier for the action.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting
     * results, and deciding which other actions will be necessary.
     * </p>
     * 
     * @return The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments,
     *         emitting results, and deciding which other actions will be necessary.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The specific HITId or AssignmentID targeted by the action.
     * </p>
     * 
     * @return The specific HITId or AssignmentID targeted by the action.
     */
    public String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of object in TargetId.
     * </p>
     * 
     * @return The type of object in TargetId.
     */
    public String targetType() {
        return targetType;
    }

    /**
     * <p>
     * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
     * @see ReviewActionStatus
     */
    public ReviewActionStatus status() {
        return ReviewActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
     * @see ReviewActionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date when the action was completed.
     * </p>
     * 
     * @return The date when the action was completed.
     */
    public Instant completeTime() {
        return completeTime;
    }

    /**
     * <p>
     * A description of the outcome of the review.
     * </p>
     * 
     * @return A description of the outcome of the review.
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * Present only when the Results have a FAILED Status.
     * </p>
     * 
     * @return Present only when the Results have a FAILED Status.
     */
    public String errorCode() {
        return errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewActionDetail)) {
            return false;
        }
        ReviewActionDetail other = (ReviewActionDetail) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(actionName(), other.actionName())
                && Objects.equals(targetId(), other.targetId()) && Objects.equals(targetType(), other.targetType())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(completeTime(), other.completeTime()) && Objects.equals(result(), other.result())
                && Objects.equals(errorCode(), other.errorCode());
    }

    @Override
    public String toString() {
        return ToString.builder("ReviewActionDetail").add("ActionId", actionId()).add("ActionName", actionName())
                .add("TargetId", targetId()).add("TargetType", targetType()).add("Status", statusAsString())
                .add("CompleteTime", completeTime()).add("Result", result()).add("ErrorCode", errorCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CompleteTime":
            return Optional.ofNullable(clazz.cast(completeTime()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReviewActionDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReviewActionDetail> {
        /**
         * <p>
         * The unique identifier for the action.
         * </p>
         * 
         * @param actionId
         *        The unique identifier for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments,
         * emitting results, and deciding which other actions will be necessary.
         * </p>
         * 
         * @param actionName
         *        The nature of the action itself. The Review Policy is responsible for examining the HIT and
         *        Assignments, emitting results, and deciding which other actions will be necessary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The specific HITId or AssignmentID targeted by the action.
         * </p>
         * 
         * @param targetId
         *        The specific HITId or AssignmentID targeted by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of object in TargetId.
         * </p>
         * 
         * @param targetType
         *        The type of object in TargetId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
         * </p>
         * 
         * @param status
         *        The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
         * @see ReviewActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
         * </p>
         * 
         * @param status
         *        The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
         * @see ReviewActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewActionStatus
         */
        Builder status(ReviewActionStatus status);

        /**
         * <p>
         * The date when the action was completed.
         * </p>
         * 
         * @param completeTime
         *        The date when the action was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeTime(Instant completeTime);

        /**
         * <p>
         * A description of the outcome of the review.
         * </p>
         * 
         * @param result
         *        A description of the outcome of the review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * Present only when the Results have a FAILED Status.
         * </p>
         * 
         * @param errorCode
         *        Present only when the Results have a FAILED Status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String actionName;

        private String targetId;

        private String targetType;

        private String status;

        private Instant completeTime;

        private String result;

        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewActionDetail model) {
            actionId(model.actionId);
            actionName(model.actionName);
            targetId(model.targetId);
            targetType(model.targetType);
            status(model.status);
            completeTime(model.completeTime);
            result(model.result);
            errorCode(model.errorCode);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getTargetId() {
            return targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewActionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCompleteTime() {
            return completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public ReviewActionDetail build() {
            return new ReviewActionDetail(this);
        }
    }
}
