/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.ReviewResultDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data structure is returned multiple times for each result specified in the Review Policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewResultDetail implements StructuredPojo,
        ToCopyableBuilder<ReviewResultDetail.Builder, ReviewResultDetail> {
    private final String actionId;

    private final String subjectId;

    private final String subjectType;

    private final String questionId;

    private final String key;

    private final String value;

    private ReviewResultDetail(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.subjectId = builder.subjectId;
        this.subjectType = builder.subjectType;
        this.questionId = builder.questionId;
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * A unique identifier of the Review action result.
     * </p>
     * 
     * @return A unique identifier of the Review action result.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit
     * results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit
     * results about the Assignment itself.
     * </p>
     * 
     * @return The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will
     *         often emit results about both the HIT itself and its Assignments, while Assignment-level review policies
     *         generally only emit results about the Assignment itself.
     */
    public String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The type of the object from the SubjectId field.
     * </p>
     * 
     * @return The type of the object from the SubjectId field.
     */
    public String subjectType() {
        return subjectType;
    }

    /**
     * <p>
     * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment
     * this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result
     * describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is
     * absent, then the result describes the Worker's performance on the HIT.
     * </p>
     * 
     * @return Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or
     *         Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent,
     *         then the result describes results of the HIT, including the HIT agreement score. If ObjectType is
     *         Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
     */
    public String questionId() {
        return questionId;
    }

    /**
     * <p>
     * Key identifies the particular piece of reviewed information.
     * </p>
     * 
     * @return Key identifies the particular piece of reviewed information.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The values of Key provided by the review policies you have selected.
     * </p>
     * 
     * @return The values of Key provided by the review policies you have selected.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectType());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewResultDetail)) {
            return false;
        }
        ReviewResultDetail other = (ReviewResultDetail) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(subjectId(), other.subjectId())
                && Objects.equals(subjectType(), other.subjectType()) && Objects.equals(questionId(), other.questionId())
                && Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("ReviewResultDetail").add("ActionId", actionId()).add("SubjectId", subjectId())
                .add("SubjectType", subjectType()).add("QuestionId", questionId()).add("Key", key()).add("Value", value())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "SubjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "SubjectType":
            return Optional.ofNullable(clazz.cast(subjectType()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReviewResultDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReviewResultDetail> {
        /**
         * <p>
         * A unique identifier of the Review action result.
         * </p>
         * 
         * @param actionId
         *        A unique identifier of the Review action result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often
         * emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally
         * only emit results about the Assignment itself.
         * </p>
         * 
         * @param subjectId
         *        The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will
         *        often emit results about both the HIT itself and its Assignments, while Assignment-level review
         *        policies generally only emit results about the Assignment itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The type of the object from the SubjectId field.
         * </p>
         * 
         * @param subjectType
         *        The type of the object from the SubjectId field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectType(String subjectType);

        /**
         * <p>
         * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment
         * this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result
         * describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId
         * is absent, then the result describes the Worker's performance on the HIT.
         * </p>
         * 
         * @param questionId
         *        Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or
         *        Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent,
         *        then the result describes results of the HIT, including the HIT agreement score. If ObjectType is
         *        Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * <p>
         * Key identifies the particular piece of reviewed information.
         * </p>
         * 
         * @param key
         *        Key identifies the particular piece of reviewed information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The values of Key provided by the review policies you have selected.
         * </p>
         * 
         * @param value
         *        The values of Key provided by the review policies you have selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String subjectId;

        private String subjectType;

        private String questionId;

        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewResultDetail model) {
            actionId(model.actionId);
            subjectId(model.subjectId);
            subjectType(model.subjectType);
            questionId(model.questionId);
            key(model.key);
            value(model.value);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        public final String getSubjectType() {
            return subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ReviewResultDetail build() {
            return new ReviewResultDetail(this);
        }
    }
}
