/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Mechanical Turk is temporarily unable to process your request. Try your call again.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceException extends MTurkException implements
        ToCopyableBuilder<ServiceException.Builder, ServiceException> {
    private final String turkErrorCode;

    private ServiceException(BuilderImpl builder) {
        super(builder);
        this.turkErrorCode = builder.turkErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the TurkErrorCode property for this object.
     * 
     * @return The value of the TurkErrorCode property for this object.
     */
    public String turkErrorCode() {
        return turkErrorCode;
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceException>, MTurkException.Builder {
        /**
         * Sets the value of the TurkErrorCode property for this object.
         *
         * @param turkErrorCode
         *        The new value for the TurkErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turkErrorCode(String turkErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MTurkException.BuilderImpl implements Builder {
        private String turkErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceException model) {
            super(model);
            turkErrorCode(model.turkErrorCode);
        }

        public final String getTurkErrorCode() {
            return turkErrorCode;
        }

        @Override
        public final Builder turkErrorCode(String turkErrorCode) {
            this.turkErrorCode = turkErrorCode;
            return this;
        }

        @JsonProperty("TurkErrorCode")
        public final void setTurkErrorCode(String turkErrorCode) {
            this.turkErrorCode = turkErrorCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceException build() {
            return new ServiceException(this);
        }
    }
}
