/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExpirationForHitRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateExpirationForHitRequest.Builder, UpdateExpirationForHitRequest> {
    private final String hitId;

    private final Instant expireAt;

    private UpdateExpirationForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.expireAt = builder.expireAt;
    }

    /**
     * <p>
     * The HIT to update.
     * </p>
     * 
     * @return The HIT to update.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The date and time at which you want the HIT to expire
     * </p>
     * 
     * @return The date and time at which you want the HIT to expire
     */
    public Instant expireAt() {
        return expireAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(expireAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExpirationForHitRequest)) {
            return false;
        }
        UpdateExpirationForHitRequest other = (UpdateExpirationForHitRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(expireAt(), other.expireAt());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateExpirationForHitRequest").add("HITId", hitId()).add("ExpireAt", expireAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "ExpireAt":
            return Optional.ofNullable(clazz.cast(expireAt()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, UpdateExpirationForHitRequest> {
        /**
         * <p>
         * The HIT to update.
         * </p>
         * 
         * @param hitId
         *        The HIT to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The date and time at which you want the HIT to expire
         * </p>
         * 
         * @param expireAt
         *        The date and time at which you want the HIT to expire
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expireAt(Instant expireAt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private Instant expireAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExpirationForHitRequest model) {
            super(model);
            hitId(model.hitId);
            expireAt(model.expireAt);
        }

        public final String getHITId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Instant getExpireAt() {
            return expireAt;
        }

        @Override
        public final Builder expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public final void setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExpirationForHitRequest build() {
            return new UpdateExpirationForHitRequest(this);
        }
    }
}
