/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHitTypeOfHitRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateHitTypeOfHitRequest.Builder, UpdateHitTypeOfHitRequest> {
    private final String hitId;

    private final String hitTypeId;

    private UpdateHitTypeOfHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.hitTypeId = builder.hitTypeId;
    }

    /**
     * <p>
     * The HIT to update.
     * </p>
     * 
     * @return The HIT to update.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The ID of the new HIT type.
     * </p>
     * 
     * @return The ID of the new HIT type.
     */
    public String hitTypeId() {
        return hitTypeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(hitTypeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHitTypeOfHitRequest)) {
            return false;
        }
        UpdateHitTypeOfHitRequest other = (UpdateHitTypeOfHitRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(hitTypeId(), other.hitTypeId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateHitTypeOfHitRequest").add("HITId", hitId()).add("HITTypeId", hitTypeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "HITTypeId":
            return Optional.ofNullable(clazz.cast(hitTypeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, UpdateHitTypeOfHitRequest> {
        /**
         * <p>
         * The HIT to update.
         * </p>
         * 
         * @param hitId
         *        The HIT to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The ID of the new HIT type.
         * </p>
         * 
         * @param hitTypeId
         *        The ID of the new HIT type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitTypeId(String hitTypeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private String hitTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHitTypeOfHitRequest model) {
            super(model);
            hitId(model.hitId);
            hitTypeId(model.hitTypeId);
        }

        public final String getHITId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final String getHITTypeId() {
            return hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHitTypeOfHitRequest build() {
            return new UpdateHitTypeOfHitRequest(this);
        }
    }
}
