/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQualificationTypeRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateQualificationTypeRequest.Builder, UpdateQualificationTypeRequest> {
    private final String qualificationTypeId;

    private final String description;

    private final String qualificationTypeStatus;

    private final String test;

    private final String answerKey;

    private final Long testDurationInSeconds;

    private final Long retryDelayInSeconds;

    private final Boolean autoGranted;

    private final Integer autoGrantedValue;

    private UpdateQualificationTypeRequest(BuilderImpl builder) {
        super(builder);
        this.qualificationTypeId = builder.qualificationTypeId;
        this.description = builder.description;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.test = builder.test;
        this.answerKey = builder.answerKey;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    /**
     * <p>
     * The ID of the Qualification type to update.
     * </p>
     * 
     * @return The ID of the Qualification type to update.
     */
    public String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * The new description of the Qualification type.
     * </p>
     * 
     * @return The new description of the Qualification type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The new status of the Qualification type - Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The new status of the Qualification type - Active | Inactive
     * @see QualificationTypeStatus
     */
    public QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(qualificationTypeStatus);
    }

    /**
     * <p>
     * The new status of the Qualification type - Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The new status of the Qualification type - Active | Inactive
     * @see QualificationTypeStatus
     */
    public String qualificationTypeStatusAsString() {
        return qualificationTypeStatus;
    }

    /**
     * <p>
     * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type.
     * If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
     * </p>
     * <p>
     * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be
     * specified if AutoGranted is true.
     * </p>
     * <p>
     * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
     * </p>
     * 
     * @return The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
     *         type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
     *         <p>
     *         Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
     *         cannot be specified if AutoGranted is true.
     *         </p>
     *         <p>
     *         Constraints: None. If not specified, the Worker may request the Qualification without answering any
     *         questions.
     */
    public String test() {
        return test;
    }

    /**
     * <p>
     * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     * structure.
     * </p>
     * 
     * @return The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     *         structure.
     */
    public String answerKey() {
        return answerKey;
    }

    /**
     * <p>
     * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
     * requests the Qualification.
     * </p>
     * 
     * @return The number of seconds the Worker has to complete the Qualification test, starting from the time the
     *         Worker requests the Qualification.
     */
    public Long testDurationInSeconds() {
        return testDurationInSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
     * Qualification type before they can retry the Qualification request. It is not possible to disable retries for a
     * Qualification type after it has been created with retries enabled. If you want to disable retries, you must
     * dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new
     * Qualification type with retries disabled using CreateQualificationType.
     * </p>
     * 
     * @return The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
     *         Qualification type before they can retry the Qualification request. It is not possible to disable retries
     *         for a Qualification type after it has been created with retries enabled. If you want to disable retries,
     *         you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then
     *         create a new Qualification type with retries disabled using CreateQualificationType.
     */
    public Long retryDelayInSeconds() {
        return retryDelayInSeconds;
    }

    /**
     * <p>
     * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with
     * a Qualification test.
     * </p>
     * <p>
     * Constraints: If the Test parameter is specified, this parameter cannot be true.
     * </p>
     * 
     * @return Specifies whether requests for the Qualification type are granted immediately, without prompting the
     *         Worker with a Qualification test.</p>
     *         <p>
     *         Constraints: If the Test parameter is specified, this parameter cannot be true.
     */
    public Boolean autoGranted() {
        return autoGranted;
    }

    /**
     * <p>
     * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
     * AutoGranted parameter is true.
     * </p>
     * 
     * @return The Qualification value to use for automatically granted Qualifications. This parameter is used only if
     *         the AutoGranted parameter is true.
     */
    public Integer autoGrantedValue() {
        return autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(autoGrantedValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQualificationTypeRequest)) {
            return false;
        }
        UpdateQualificationTypeRequest other = (UpdateQualificationTypeRequest) obj;
        return Objects.equals(qualificationTypeId(), other.qualificationTypeId())
                && Objects.equals(description(), other.description())
                && Objects.equals(qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString())
                && Objects.equals(test(), other.test()) && Objects.equals(answerKey(), other.answerKey())
                && Objects.equals(testDurationInSeconds(), other.testDurationInSeconds())
                && Objects.equals(retryDelayInSeconds(), other.retryDelayInSeconds())
                && Objects.equals(autoGranted(), other.autoGranted())
                && Objects.equals(autoGrantedValue(), other.autoGrantedValue());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateQualificationTypeRequest").add("QualificationTypeId", qualificationTypeId())
                .add("Description", description()).add("QualificationTypeStatus", qualificationTypeStatusAsString())
                .add("Test", test()).add("AnswerKey", answerKey()).add("TestDurationInSeconds", testDurationInSeconds())
                .add("RetryDelayInSeconds", retryDelayInSeconds()).add("AutoGranted", autoGranted())
                .add("AutoGrantedValue", autoGrantedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "QualificationTypeStatus":
            return Optional.ofNullable(clazz.cast(qualificationTypeStatusAsString()));
        case "Test":
            return Optional.ofNullable(clazz.cast(test()));
        case "AnswerKey":
            return Optional.ofNullable(clazz.cast(answerKey()));
        case "TestDurationInSeconds":
            return Optional.ofNullable(clazz.cast(testDurationInSeconds()));
        case "RetryDelayInSeconds":
            return Optional.ofNullable(clazz.cast(retryDelayInSeconds()));
        case "AutoGranted":
            return Optional.ofNullable(clazz.cast(autoGranted()));
        case "AutoGrantedValue":
            return Optional.ofNullable(clazz.cast(autoGrantedValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MTurkRequest.Builder, CopyableBuilder<Builder, UpdateQualificationTypeRequest> {
        /**
         * <p>
         * The ID of the Qualification type to update.
         * </p>
         * 
         * @param qualificationTypeId
         *        The ID of the Qualification type to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * The new description of the Qualification type.
         * </p>
         * 
         * @param description
         *        The new description of the Qualification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new status of the Qualification type - Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The new status of the Qualification type - Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(String qualificationTypeStatus);

        /**
         * <p>
         * The new status of the Qualification type - Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The new status of the Qualification type - Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus);

        /**
         * <p>
         * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
         * type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
         * </p>
         * <p>
         * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
         * cannot be specified if AutoGranted is true.
         * </p>
         * <p>
         * Constraints: None. If not specified, the Worker may request the Qualification without answering any
         * questions.
         * </p>
         * 
         * @param test
         *        The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of
         *        this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be
         *        specified.</p>
         *        <p>
         *        Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This
         *        parameter cannot be specified if AutoGranted is true.
         *        </p>
         *        <p>
         *        Constraints: None. If not specified, the Worker may request the Qualification without answering any
         *        questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(String test);

        /**
         * <p>
         * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
         * structure.
         * </p>
         * 
         * @param answerKey
         *        The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey
         *        data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerKey(String answerKey);

        /**
         * <p>
         * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
         * requests the Qualification.
         * </p>
         * 
         * @param testDurationInSeconds
         *        The number of seconds the Worker has to complete the Qualification test, starting from the time the
         *        Worker requests the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInSeconds(Long testDurationInSeconds);

        /**
         * <p>
         * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
         * Qualification type before they can retry the Qualification request. It is not possible to disable retries for
         * a Qualification type after it has been created with retries enabled. If you want to disable retries, you must
         * dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new
         * Qualification type with retries disabled using CreateQualificationType.
         * </p>
         * 
         * @param retryDelayInSeconds
         *        The amount of time, in seconds, that Workers must wait after requesting a Qualification of the
         *        specified Qualification type before they can retry the Qualification request. It is not possible to
         *        disable retries for a Qualification type after it has been created with retries enabled. If you want
         *        to disable retries, you must dispose of the existing retry-enabled Qualification type using
         *        DisposeQualificationType and then create a new Qualification type with retries disabled using
         *        CreateQualificationType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryDelayInSeconds(Long retryDelayInSeconds);

        /**
         * <p>
         * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker
         * with a Qualification test.
         * </p>
         * <p>
         * Constraints: If the Test parameter is specified, this parameter cannot be true.
         * </p>
         * 
         * @param autoGranted
         *        Specifies whether requests for the Qualification type are granted immediately, without prompting the
         *        Worker with a Qualification test.</p>
         *        <p>
         *        Constraints: If the Test parameter is specified, this parameter cannot be true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGranted(Boolean autoGranted);

        /**
         * <p>
         * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
         * AutoGranted parameter is true.
         * </p>
         * 
         * @param autoGrantedValue
         *        The Qualification value to use for automatically granted Qualifications. This parameter is used only
         *        if the AutoGranted parameter is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGrantedValue(Integer autoGrantedValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String qualificationTypeId;

        private String description;

        private String qualificationTypeStatus;

        private String test;

        private String answerKey;

        private Long testDurationInSeconds;

        private Long retryDelayInSeconds;

        private Boolean autoGranted;

        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQualificationTypeRequest model) {
            super(model);
            qualificationTypeId(model.qualificationTypeId);
            description(model.description);
            qualificationTypeStatus(model.qualificationTypeStatus);
            test(model.test);
            answerKey(model.answerKey);
            testDurationInSeconds(model.testDurationInSeconds);
            retryDelayInSeconds(model.retryDelayInSeconds);
            autoGranted(model.autoGranted);
            autoGrantedValue(model.autoGrantedValue);
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQualificationTypeStatus() {
            return qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus.toString());
            return this;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        public final String getTest() {
            return test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        public final String getAnswerKey() {
            return answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        public final Long getTestDurationInSeconds() {
            return testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        public final Long getRetryDelayInSeconds() {
            return retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public final Boolean getAutoGranted() {
            return autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        public final Integer getAutoGrantedValue() {
            return autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQualificationTypeRequest build() {
            return new UpdateQualificationTypeRequest(this);
        }
    }
}
