/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.WorkerBlockMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The WorkerBlock data structure represents a Worker who has been blocked. It has two elements: the WorkerId and the
 * Reason for the block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerBlock implements StructuredPojo, ToCopyableBuilder<WorkerBlock.Builder, WorkerBlock> {
    private final String workerId;

    private final String reason;

    private WorkerBlock(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The ID of the Worker who accepted the HIT.
     * </p>
     * 
     * @return The ID of the Worker who accepted the HIT.
     */
    public String workerId() {
        return workerId;
    }

    /**
     * <p>
     * A message explaining the reason the Worker was blocked.
     * </p>
     * 
     * @return A message explaining the reason the Worker was blocked.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerBlock)) {
            return false;
        }
        WorkerBlock other = (WorkerBlock) obj;
        return Objects.equals(workerId(), other.workerId()) && Objects.equals(reason(), other.reason());
    }

    @Override
    public String toString() {
        return ToString.builder("WorkerBlock").add("WorkerId", workerId()).add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkerBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkerBlock> {
        /**
         * <p>
         * The ID of the Worker who accepted the HIT.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker who accepted the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * A message explaining the reason the Worker was blocked.
         * </p>
         * 
         * @param reason
         *        A message explaining the reason the Worker was blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String workerId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerBlock model) {
            workerId(model.workerId);
            reason(model.reason);
        }

        public final String getWorkerId() {
            return workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public WorkerBlock build() {
            return new WorkerBlock(this);
        }
    }
}
