/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.Assignment;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Assignment} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AssignmentMarshaller {
    private static final MarshallingInfo<String> ASSIGNMENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentId").isBinary(false).build();

    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();

    private static final MarshallingInfo<String> HITID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITId").isBinary(false).build();

    private static final MarshallingInfo<String> ASSIGNMENTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> AUTOAPPROVALTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> ACCEPTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> APPROVALTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> REJECTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RejectionTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> DEADLINE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deadline").isBinary(false).build();

    private static final MarshallingInfo<String> ANSWER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Answer").isBinary(false).build();

    private static final MarshallingInfo<String> REQUESTERFEEDBACK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterFeedback").isBinary(false).build();

    private static final AssignmentMarshaller INSTANCE = new AssignmentMarshaller();

    private AssignmentMarshaller() {
    }

    public static AssignmentMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Assignment assignment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(assignment, "assignment");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(assignment.assignmentId(), ASSIGNMENTID_BINDING);
            protocolMarshaller.marshall(assignment.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall(assignment.hitId(), HITID_BINDING);
            protocolMarshaller.marshall(assignment.assignmentStatusAsString(), ASSIGNMENTSTATUS_BINDING);
            protocolMarshaller.marshall(assignment.autoApprovalTime(), AUTOAPPROVALTIME_BINDING);
            protocolMarshaller.marshall(assignment.acceptTime(), ACCEPTTIME_BINDING);
            protocolMarshaller.marshall(assignment.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall(assignment.approvalTime(), APPROVALTIME_BINDING);
            protocolMarshaller.marshall(assignment.rejectionTime(), REJECTIONTIME_BINDING);
            protocolMarshaller.marshall(assignment.deadline(), DEADLINE_BINDING);
            protocolMarshaller.marshall(assignment.answer(), ANSWER_BINDING);
            protocolMarshaller.marshall(assignment.requesterFeedback(), REQUESTERFEEDBACK_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
