/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Assignment JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssignmentUnmarshaller implements Unmarshaller<Assignment, JsonUnmarshallerContext> {

    public Assignment unmarshall(JsonUnmarshallerContext context) throws Exception {
        Assignment.Builder assignmentBuilder = Assignment.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AssignmentId", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.assignmentId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WorkerId", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.workerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HITId", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.hitId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AssignmentStatus", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.assignmentStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoApprovalTime", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.autoApprovalTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("AcceptTime", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.acceptTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("SubmitTime", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.submitTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("ApprovalTime", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.approvalTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("RejectionTime", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.rejectionTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Deadline", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.deadline(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Answer", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.answer(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RequesterFeedback", targetDepth)) {
                    context.nextToken();
                    assignmentBuilder.requesterFeedback(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return assignmentBuilder.build();
    }

    private static final AssignmentUnmarshaller INSTANCE = new AssignmentUnmarshaller();

    public static AssignmentUnmarshaller getInstance() {
        return INSTANCE;
    }
}
