/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateHitRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateHitRequestModelMarshaller {
    private static final MarshallingInfo<Integer> MAXASSIGNMENTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAssignments").isBinary(false).build();

    private static final MarshallingInfo<Long> AUTOAPPROVALDELAYINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalDelayInSeconds").isBinary(false)
            .build();

    private static final MarshallingInfo<Long> LIFETIMEINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifetimeInSeconds").isBinary(false).build();

    private static final MarshallingInfo<Long> ASSIGNMENTDURATIONINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AssignmentDurationInSeconds").isBinary(false).build();

    private static final MarshallingInfo<String> REWARD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reward").isBinary(false).build();

    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();

    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> QUESTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Question").isBinary(false).build();

    private static final MarshallingInfo<String> REQUESTERANNOTATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAnnotation").isBinary(false).build();

    private static final MarshallingInfo<List> QUALIFICATIONREQUIREMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequirements").isBinary(false).build();

    private static final MarshallingInfo<String> UNIQUEREQUESTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniqueRequestToken").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ASSIGNMENTREVIEWPOLICY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AssignmentReviewPolicy").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> HITREVIEWPOLICY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("HITReviewPolicy").isBinary(false).build();

    private static final MarshallingInfo<String> HITLAYOUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutId").isBinary(false).build();

    private static final MarshallingInfo<List> HITLAYOUTPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutParameters").isBinary(false).build();

    private static final CreateHitRequestModelMarshaller INSTANCE = new CreateHitRequestModelMarshaller();

    private CreateHitRequestModelMarshaller() {
    }

    public static CreateHitRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateHitRequest createHitRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createHitRequest, "createHitRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createHitRequest.maxAssignments(), MAXASSIGNMENTS_BINDING);
            protocolMarshaller.marshall(createHitRequest.autoApprovalDelayInSeconds(), AUTOAPPROVALDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall(createHitRequest.lifetimeInSeconds(), LIFETIMEINSECONDS_BINDING);
            protocolMarshaller.marshall(createHitRequest.assignmentDurationInSeconds(), ASSIGNMENTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(createHitRequest.reward(), REWARD_BINDING);
            protocolMarshaller.marshall(createHitRequest.title(), TITLE_BINDING);
            protocolMarshaller.marshall(createHitRequest.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall(createHitRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createHitRequest.question(), QUESTION_BINDING);
            protocolMarshaller.marshall(createHitRequest.requesterAnnotation(), REQUESTERANNOTATION_BINDING);
            protocolMarshaller.marshall(createHitRequest.qualificationRequirements(), QUALIFICATIONREQUIREMENTS_BINDING);
            protocolMarshaller.marshall(createHitRequest.uniqueRequestToken(), UNIQUEREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall(createHitRequest.assignmentReviewPolicy(), ASSIGNMENTREVIEWPOLICY_BINDING);
            protocolMarshaller.marshall(createHitRequest.hitReviewPolicy(), HITREVIEWPOLICY_BINDING);
            protocolMarshaller.marshall(createHitRequest.hitLayoutId(), HITLAYOUTID_BINDING);
            protocolMarshaller.marshall(createHitRequest.hitLayoutParameters(), HITLAYOUTPARAMETERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
