/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateQualificationTypeRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateQualificationTypeRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> QUALIFICATIONTYPESTATUS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("QualificationTypeStatus").isBinary(false).build();

    private static final MarshallingInfo<Long> RETRYDELAYINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryDelayInSeconds").isBinary(false).build();

    private static final MarshallingInfo<String> TEST_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Test").isBinary(false).build();

    private static final MarshallingInfo<String> ANSWERKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnswerKey").isBinary(false).build();

    private static final MarshallingInfo<Long> TESTDURATIONINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TestDurationInSeconds").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOGRANTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoGranted").isBinary(false).build();

    private static final MarshallingInfo<Integer> AUTOGRANTEDVALUE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoGrantedValue").isBinary(false).build();

    private static final CreateQualificationTypeRequestModelMarshaller INSTANCE = new CreateQualificationTypeRequestModelMarshaller();

    private CreateQualificationTypeRequestModelMarshaller() {
    }

    public static CreateQualificationTypeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateQualificationTypeRequest createQualificationTypeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createQualificationTypeRequest, "createQualificationTypeRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createQualificationTypeRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.qualificationTypeStatusAsString(),
                    QUALIFICATIONTYPESTATUS_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.retryDelayInSeconds(), RETRYDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.test(), TEST_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.answerKey(), ANSWERKEY_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.testDurationInSeconds(), TESTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.autoGranted(), AUTOGRANTED_BINDING);
            protocolMarshaller.marshall(createQualificationTypeRequest.autoGrantedValue(), AUTOGRANTEDVALUE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
