/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.HIT;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link HIT} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class HITMarshaller {
    private static final MarshallingInfo<String> HITID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITId").isBinary(false).build();

    private static final MarshallingInfo<String> HITTYPEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITTypeId").isBinary(false).build();

    private static final MarshallingInfo<String> HITGROUPID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITGroupId").isBinary(false).build();

    private static final MarshallingInfo<String> HITLAYOUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutId").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();

    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> QUESTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Question").isBinary(false).build();

    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();

    private static final MarshallingInfo<String> HITSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITStatus").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXASSIGNMENTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAssignments").isBinary(false).build();

    private static final MarshallingInfo<String> REWARD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reward").isBinary(false).build();

    private static final MarshallingInfo<Long> AUTOAPPROVALDELAYINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalDelayInSeconds").isBinary(false)
            .build();

    private static final MarshallingInfo<Instant> EXPIRATION_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiration").isBinary(false).build();

    private static final MarshallingInfo<Long> ASSIGNMENTDURATIONINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AssignmentDurationInSeconds").isBinary(false).build();

    private static final MarshallingInfo<String> REQUESTERANNOTATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAnnotation").isBinary(false).build();

    private static final MarshallingInfo<List> QUALIFICATIONREQUIREMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequirements").isBinary(false).build();

    private static final MarshallingInfo<String> HITREVIEWSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITReviewStatus").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSPENDING_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NumberOfAssignmentsPending").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSAVAILABLE_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NumberOfAssignmentsAvailable").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSCOMPLETED_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NumberOfAssignmentsCompleted").isBinary(false).build();

    private static final HITMarshaller INSTANCE = new HITMarshaller();

    private HITMarshaller() {
    }

    public static HITMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(HIT hit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(hit, "hit");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(hit.hitId(), HITID_BINDING);
            protocolMarshaller.marshall(hit.hitTypeId(), HITTYPEID_BINDING);
            protocolMarshaller.marshall(hit.hitGroupId(), HITGROUPID_BINDING);
            protocolMarshaller.marshall(hit.hitLayoutId(), HITLAYOUTID_BINDING);
            protocolMarshaller.marshall(hit.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(hit.title(), TITLE_BINDING);
            protocolMarshaller.marshall(hit.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(hit.question(), QUESTION_BINDING);
            protocolMarshaller.marshall(hit.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall(hit.hitStatusAsString(), HITSTATUS_BINDING);
            protocolMarshaller.marshall(hit.maxAssignments(), MAXASSIGNMENTS_BINDING);
            protocolMarshaller.marshall(hit.reward(), REWARD_BINDING);
            protocolMarshaller.marshall(hit.autoApprovalDelayInSeconds(), AUTOAPPROVALDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall(hit.expiration(), EXPIRATION_BINDING);
            protocolMarshaller.marshall(hit.assignmentDurationInSeconds(), ASSIGNMENTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(hit.requesterAnnotation(), REQUESTERANNOTATION_BINDING);
            protocolMarshaller.marshall(hit.qualificationRequirements(), QUALIFICATIONREQUIREMENTS_BINDING);
            protocolMarshaller.marshall(hit.hitReviewStatusAsString(), HITREVIEWSTATUS_BINDING);
            protocolMarshaller.marshall(hit.numberOfAssignmentsPending(), NUMBEROFASSIGNMENTSPENDING_BINDING);
            protocolMarshaller.marshall(hit.numberOfAssignmentsAvailable(), NUMBEROFASSIGNMENTSAVAILABLE_BINDING);
            protocolMarshaller.marshall(hit.numberOfAssignmentsCompleted(), NUMBEROFASSIGNMENTSCOMPLETED_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
