/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * HIT JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HITUnmarshaller implements Unmarshaller<HIT, JsonUnmarshallerContext> {

    public HIT unmarshall(JsonUnmarshallerContext context) throws Exception {
        HIT.Builder hitBuilder = HIT.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("HITId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HITTypeId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitTypeId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HITGroupId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitGroupId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HITLayoutId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitLayoutId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    hitBuilder.creationTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    hitBuilder.title(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    hitBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Question", targetDepth)) {
                    context.nextToken();
                    hitBuilder.question(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Keywords", targetDepth)) {
                    context.nextToken();
                    hitBuilder.keywords(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HITStatus", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MaxAssignments", targetDepth)) {
                    context.nextToken();
                    hitBuilder.maxAssignments(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Reward", targetDepth)) {
                    context.nextToken();
                    hitBuilder.reward(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoApprovalDelayInSeconds", targetDepth)) {
                    context.nextToken();
                    hitBuilder.autoApprovalDelayInSeconds(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Expiration", targetDepth)) {
                    context.nextToken();
                    hitBuilder.expiration(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("AssignmentDurationInSeconds", targetDepth)) {
                    context.nextToken();
                    hitBuilder.assignmentDurationInSeconds(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("RequesterAnnotation", targetDepth)) {
                    context.nextToken();
                    hitBuilder.requesterAnnotation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("QualificationRequirements", targetDepth)) {
                    context.nextToken();
                    hitBuilder.qualificationRequirements(new ListUnmarshaller<QualificationRequirement>(
                            QualificationRequirementUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("HITReviewStatus", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitReviewStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfAssignmentsPending", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsPending(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfAssignmentsAvailable", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsAvailable(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfAssignmentsCompleted", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsCompleted(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return hitBuilder.build();
    }

    private static final HITUnmarshaller INSTANCE = new HITUnmarshaller();

    public static HITUnmarshaller getInstance() {
        return INSTANCE;
    }
}
