/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListQualificationTypesRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListQualificationTypesRequestModelMarshaller {
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Query").isBinary(false).build();

    private static final MarshallingInfo<Boolean> MUSTBEREQUESTABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MustBeRequestable").isBinary(false).build();

    private static final MarshallingInfo<Boolean> MUSTBEOWNEDBYCALLER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MustBeOwnedByCaller").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();

    private static final ListQualificationTypesRequestModelMarshaller INSTANCE = new ListQualificationTypesRequestModelMarshaller();

    private ListQualificationTypesRequestModelMarshaller() {
    }

    public static ListQualificationTypesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListQualificationTypesRequest listQualificationTypesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listQualificationTypesRequest, "listQualificationTypesRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listQualificationTypesRequest.query(), QUERY_BINDING);
            protocolMarshaller.marshall(listQualificationTypesRequest.mustBeRequestable(), MUSTBEREQUESTABLE_BINDING);
            protocolMarshaller.marshall(listQualificationTypesRequest.mustBeOwnedByCaller(), MUSTBEOWNEDBYCALLER_BINDING);
            protocolMarshaller.marshall(listQualificationTypesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listQualificationTypesRequest.maxResults(), MAXRESULTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
