/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * NotifyWorkersFailureStatus JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NotifyWorkersFailureStatusUnmarshaller implements Unmarshaller<NotifyWorkersFailureStatus, JsonUnmarshallerContext> {

    public NotifyWorkersFailureStatus unmarshall(JsonUnmarshallerContext context) throws Exception {
        NotifyWorkersFailureStatus.Builder notifyWorkersFailureStatusBuilder = NotifyWorkersFailureStatus.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("NotifyWorkersFailureCode", targetDepth)) {
                    context.nextToken();
                    notifyWorkersFailureStatusBuilder.notifyWorkersFailureCode(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("NotifyWorkersFailureMessage", targetDepth)) {
                    context.nextToken();
                    notifyWorkersFailureStatusBuilder.notifyWorkersFailureMessage(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("WorkerId", targetDepth)) {
                    context.nextToken();
                    notifyWorkersFailureStatusBuilder.workerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return notifyWorkersFailureStatusBuilder.build();
    }

    private static final NotifyWorkersFailureStatusUnmarshaller INSTANCE = new NotifyWorkersFailureStatusUnmarshaller();

    public static NotifyWorkersFailureStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}
