/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.QualificationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link QualificationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class QualificationRequestMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONREQUESTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequestId").isBinary(false).build();

    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();

    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();

    private static final MarshallingInfo<String> TEST_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Test").isBinary(false).build();

    private static final MarshallingInfo<String> ANSWER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Answer").isBinary(false).build();

    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();

    private static final QualificationRequestMarshaller INSTANCE = new QualificationRequestMarshaller();

    private QualificationRequestMarshaller() {
    }

    public static QualificationRequestMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(QualificationRequest qualificationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(qualificationRequest, "qualificationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(qualificationRequest.qualificationRequestId(), QUALIFICATIONREQUESTID_BINDING);
            protocolMarshaller.marshall(qualificationRequest.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall(qualificationRequest.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall(qualificationRequest.test(), TEST_BINDING);
            protocolMarshaller.marshall(qualificationRequest.answer(), ANSWER_BINDING);
            protocolMarshaller.marshall(qualificationRequest.submitTime(), SUBMITTIME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
