/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link QualificationRequirement} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class QualificationRequirementMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();

    private static final MarshallingInfo<String> COMPARATOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comparator").isBinary(false).build();

    private static final MarshallingInfo<List> INTEGERVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerValues").isBinary(false).build();

    private static final MarshallingInfo<List> LOCALEVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocaleValues").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIREDTOPREVIEW_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequiredToPreview").isBinary(false).build();

    private static final MarshallingInfo<String> ACTIONSGUARDED_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsGuarded").isBinary(false).build();

    private static final QualificationRequirementMarshaller INSTANCE = new QualificationRequirementMarshaller();

    private QualificationRequirementMarshaller() {
    }

    public static QualificationRequirementMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(QualificationRequirement qualificationRequirement, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(qualificationRequirement, "qualificationRequirement");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(qualificationRequirement.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.comparatorAsString(), COMPARATOR_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.integerValues(), INTEGERVALUES_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.localeValues(), LOCALEVALUES_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.requiredToPreview(), REQUIREDTOPREVIEW_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.actionsGuardedAsString(), ACTIONSGUARDED_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
