/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * QualificationType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class QualificationTypeUnmarshaller implements Unmarshaller<QualificationType, JsonUnmarshallerContext> {

    public QualificationType unmarshall(JsonUnmarshallerContext context) throws Exception {
        QualificationType.Builder qualificationTypeBuilder = QualificationType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("QualificationTypeId", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.qualificationTypeId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.creationTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Keywords", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.keywords(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("QualificationTypeStatus", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.qualificationTypeStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Test", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.test(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TestDurationInSeconds", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.testDurationInSeconds(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("AnswerKey", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.answerKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RetryDelayInSeconds", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.retryDelayInSeconds(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("IsRequestable", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.isRequestable(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoGranted", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.autoGranted(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoGrantedValue", targetDepth)) {
                    context.nextToken();
                    qualificationTypeBuilder.autoGrantedValue(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return qualificationTypeBuilder.build();
    }

    private static final QualificationTypeUnmarshaller INSTANCE = new QualificationTypeUnmarshaller();

    public static QualificationTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
