/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ReviewActionDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ReviewActionDetailMarshaller {
    private static final MarshallingInfo<String> ACTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionId").isBinary(false).build();

    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionName").isBinary(false).build();

    private static final MarshallingInfo<String> TARGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetId").isBinary(false).build();

    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetType").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<Instant> COMPLETETIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompleteTime").isBinary(false).build();

    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Result").isBinary(false).build();

    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();

    private static final ReviewActionDetailMarshaller INSTANCE = new ReviewActionDetailMarshaller();

    private ReviewActionDetailMarshaller() {
    }

    public static ReviewActionDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ReviewActionDetail reviewActionDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(reviewActionDetail, "reviewActionDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(reviewActionDetail.actionId(), ACTIONID_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.actionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.targetId(), TARGETID_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.targetType(), TARGETTYPE_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.completeTime(), COMPLETETIME_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.result(), RESULT_BINDING);
            protocolMarshaller.marshall(reviewActionDetail.errorCode(), ERRORCODE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
