/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ReviewActionDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReviewActionDetailUnmarshaller implements Unmarshaller<ReviewActionDetail, JsonUnmarshallerContext> {

    public ReviewActionDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReviewActionDetail.Builder reviewActionDetailBuilder = ReviewActionDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ActionId", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.actionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ActionName", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.actionName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TargetId", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.targetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TargetType", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.targetType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CompleteTime", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.completeTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Result", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.result(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ErrorCode", targetDepth)) {
                    context.nextToken();
                    reviewActionDetailBuilder.errorCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return reviewActionDetailBuilder.build();
    }

    private static final ReviewActionDetailUnmarshaller INSTANCE = new ReviewActionDetailUnmarshaller();

    public static ReviewActionDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
