/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SendBonusRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SendBonusRequestModelMarshaller {
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();

    private static final MarshallingInfo<String> BONUSAMOUNT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BonusAmount").isBinary(false).build();

    private static final MarshallingInfo<String> ASSIGNMENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentId").isBinary(false).build();

    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reason").isBinary(false).build();

    private static final MarshallingInfo<String> UNIQUEREQUESTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniqueRequestToken").isBinary(false).build();

    private static final SendBonusRequestModelMarshaller INSTANCE = new SendBonusRequestModelMarshaller();

    private SendBonusRequestModelMarshaller() {
    }

    public static SendBonusRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SendBonusRequest sendBonusRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(sendBonusRequest, "sendBonusRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(sendBonusRequest.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall(sendBonusRequest.bonusAmount(), BONUSAMOUNT_BINDING);
            protocolMarshaller.marshall(sendBonusRequest.assignmentId(), ASSIGNMENTID_BINDING);
            protocolMarshaller.marshall(sendBonusRequest.reason(), REASON_BINDING);
            protocolMarshaller.marshall(sendBonusRequest.uniqueRequestToken(), UNIQUEREQUESTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
