/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mturk.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateHitReviewStatusResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateHitReviewStatusResponseUnmarshaller implements
        Unmarshaller<UpdateHitReviewStatusResponse, JsonUnmarshallerContext> {

    public UpdateHitReviewStatusResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateHitReviewStatusResponse.Builder updateHitReviewStatusResponseBuilder = UpdateHitReviewStatusResponse.builder();

        return updateHitReviewStatusResponseBuilder.build();
    }

    private static final UpdateHitReviewStatusResponseUnmarshaller INSTANCE = new UpdateHitReviewStatusResponseUnmarshaller();

    public static UpdateHitReviewStatusResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
