/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQualificationRequestsResponse extends MTurkResponse implements
        ToCopyableBuilder<ListQualificationRequestsResponse.Builder, ListQualificationRequestsResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListQualificationRequestsResponse::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListQualificationRequestsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<QualificationRequest>> QUALIFICATION_REQUESTS_FIELD = SdkField
            .<List<QualificationRequest>> builder(MarshallingType.LIST)
            .getter(getter(ListQualificationRequestsResponse::qualificationRequests))
            .setter(setter(Builder::qualificationRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QualificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(QualificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, QUALIFICATION_REQUESTS_FIELD));

    private final Integer numResults;

    private final String nextToken;

    private final List<QualificationRequest> qualificationRequests;

    private ListQualificationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.qualificationRequests = builder.qualificationRequests;
    }

    /**
     * <p>
     * The number of Qualification requests on this page in the filtered results list, equivalent to the number of
     * Qualification requests being returned by this call.
     * </p>
     * 
     * @return The number of Qualification requests on this page in the filtered results list, equivalent to the number
     *         of Qualification requests being returned by this call.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Qualification request. The response includes one QualificationRequest element for each Qualification request
     * returned by the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Qualification request. The response includes one QualificationRequest element for each Qualification
     *         request returned by the query.
     */
    public List<QualificationRequest> qualificationRequests() {
        return qualificationRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationRequestsResponse)) {
            return false;
        }
        ListQualificationRequestsResponse other = (ListQualificationRequestsResponse) obj;
        return Objects.equals(numResults(), other.numResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(qualificationRequests(), other.qualificationRequests());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQualificationRequestsResponse").add("NumResults", numResults())
                .add("NextToken", nextToken()).add("QualificationRequests", qualificationRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "QualificationRequests":
            return Optional.ofNullable(clazz.cast(qualificationRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationRequestsResponse, T> g) {
        return obj -> g.apply((ListQualificationRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQualificationRequestsResponse> {
        /**
         * <p>
         * The number of Qualification requests on this page in the filtered results list, equivalent to the number of
         * Qualification requests being returned by this call.
         * </p>
         * 
         * @param numResults
         *        The number of Qualification requests on this page in the filtered results list, equivalent to the
         *        number of Qualification requests being returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Qualification request. The response includes one QualificationRequest element for each Qualification
         * request returned by the query.
         * </p>
         * 
         * @param qualificationRequests
         *        The Qualification request. The response includes one QualificationRequest element for each
         *        Qualification request returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequests(Collection<QualificationRequest> qualificationRequests);

        /**
         * <p>
         * The Qualification request. The response includes one QualificationRequest element for each Qualification
         * request returned by the query.
         * </p>
         * 
         * @param qualificationRequests
         *        The Qualification request. The response includes one QualificationRequest element for each
         *        Qualification request returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequests(QualificationRequest... qualificationRequests);

        /**
         * <p>
         * The Qualification request. The response includes one QualificationRequest element for each Qualification
         * request returned by the query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QualificationRequest>.Builder} avoiding the
         * need to create one manually via {@link List<QualificationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QualificationRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #qualificationRequests(List<QualificationRequest>)}.
         * 
         * @param qualificationRequests
         *        a consumer that will call methods on {@link List<QualificationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationRequests(List<QualificationRequest>)
         */
        Builder qualificationRequests(Consumer<QualificationRequest.Builder>... qualificationRequests);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private Integer numResults;

        private String nextToken;

        private List<QualificationRequest> qualificationRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationRequestsResponse model) {
            super(model);
            numResults(model.numResults);
            nextToken(model.nextToken);
            qualificationRequests(model.qualificationRequests);
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QualificationRequest.Builder> getQualificationRequests() {
            return qualificationRequests != null ? qualificationRequests.stream().map(QualificationRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationRequests(Collection<QualificationRequest> qualificationRequests) {
            this.qualificationRequests = QualificationRequestListCopier.copy(qualificationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequests(QualificationRequest... qualificationRequests) {
            qualificationRequests(Arrays.asList(qualificationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequests(Consumer<QualificationRequest.Builder>... qualificationRequests) {
            qualificationRequests(Stream.of(qualificationRequests)
                    .map(c -> QualificationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequests(Collection<QualificationRequest.BuilderImpl> qualificationRequests) {
            this.qualificationRequests = QualificationRequestListCopier.copyFromBuilder(qualificationRequests);
        }

        @Override
        public ListQualificationRequestsResponse build() {
            return new ListQualificationRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
