/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNotificationSettingsRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateNotificationSettingsRequest.Builder, UpdateNotificationSettingsRequest> {
    private static final SdkField<String> HIT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotificationSettingsRequest::hitTypeId)).setter(setter(Builder::hitTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITTypeId").build()).build();

    private static final SdkField<NotificationSpecification> NOTIFICATION_FIELD = SdkField
            .<NotificationSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateNotificationSettingsRequest::notification)).setter(setter(Builder::notification))
            .constructor(NotificationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNotificationSettingsRequest::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_TYPE_ID_FIELD,
            NOTIFICATION_FIELD, ACTIVE_FIELD));

    private final String hitTypeId;

    private final NotificationSpecification notification;

    private final Boolean active;

    private UpdateNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.notification = builder.notification;
        this.active = builder.active;
    }

    /**
     * <p>
     * The ID of the HIT type whose notification specification is being updated.
     * </p>
     * 
     * @return The ID of the HIT type whose notification specification is being updated.
     */
    public String hitTypeId() {
        return hitTypeId;
    }

    /**
     * <p>
     * The notification specification for the HIT type.
     * </p>
     * 
     * @return The notification specification for the HIT type.
     */
    public NotificationSpecification notification() {
        return notification;
    }

    /**
     * <p>
     * Specifies whether notifications are sent for HITs of this HIT type, according to the notification specification.
     * You must specify either the Notification parameter or the Active parameter for the call to
     * UpdateNotificationSettings to succeed.
     * </p>
     * 
     * @return Specifies whether notifications are sent for HITs of this HIT type, according to the notification
     *         specification. You must specify either the Notification parameter or the Active parameter for the call to
     *         UpdateNotificationSettings to succeed.
     */
    public Boolean active() {
        return active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationSettingsRequest)) {
            return false;
        }
        UpdateNotificationSettingsRequest other = (UpdateNotificationSettingsRequest) obj;
        return Objects.equals(hitTypeId(), other.hitTypeId()) && Objects.equals(notification(), other.notification())
                && Objects.equals(active(), other.active());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateNotificationSettingsRequest").add("HITTypeId", hitTypeId())
                .add("Notification", notification()).add("Active", active()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITTypeId":
            return Optional.ofNullable(clazz.cast(hitTypeId()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationSettingsRequest, T> g) {
        return obj -> g.apply((UpdateNotificationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNotificationSettingsRequest> {
        /**
         * <p>
         * The ID of the HIT type whose notification specification is being updated.
         * </p>
         * 
         * @param hitTypeId
         *        The ID of the HIT type whose notification specification is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitTypeId(String hitTypeId);

        /**
         * <p>
         * The notification specification for the HIT type.
         * </p>
         * 
         * @param notification
         *        The notification specification for the HIT type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(NotificationSpecification notification);

        /**
         * <p>
         * The notification specification for the HIT type.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationSpecification.Builder} avoiding the
         * need to create one manually via {@link NotificationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #notification(NotificationSpecification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link NotificationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(NotificationSpecification)
         */
        default Builder notification(Consumer<NotificationSpecification.Builder> notification) {
            return notification(NotificationSpecification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * Specifies whether notifications are sent for HITs of this HIT type, according to the notification
         * specification. You must specify either the Notification parameter or the Active parameter for the call to
         * UpdateNotificationSettings to succeed.
         * </p>
         * 
         * @param active
         *        Specifies whether notifications are sent for HITs of this HIT type, according to the notification
         *        specification. You must specify either the Notification parameter or the Active parameter for the call
         *        to UpdateNotificationSettings to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitTypeId;

        private NotificationSpecification notification;

        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationSettingsRequest model) {
            super(model);
            hitTypeId(model.hitTypeId);
            notification(model.notification);
            active(model.active);
        }

        public final String getHITTypeId() {
            return hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final NotificationSpecification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(NotificationSpecification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(NotificationSpecification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Boolean getActive() {
            return active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationSettingsRequest build() {
            return new UpdateNotificationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
