/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * HIT Review Policy data structures represent HIT review policies, which you specify when you create a HIT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ReviewPolicy.Builder, ReviewPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<List<PolicyParameter>> PARAMETERS_FIELD = SdkField
            .<List<PolicyParameter>> builder(MarshallingType.LIST)
            .getter(getter(ReviewPolicy::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final List<PolicyParameter> parameters;

    private ReviewPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
     * </p>
     * 
     * @return Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
     */
    public String policyName() {
        return policyName;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the parameter from the Review policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Name of the parameter from the Review policy.
     */
    public List<PolicyParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewPolicy)) {
            return false;
        }
        ReviewPolicy other = (ReviewPolicy) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReviewPolicy").add("PolicyName", policyName()).add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewPolicy, T> g) {
        return obj -> g.apply((ReviewPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewPolicy> {
        /**
         * <p>
         * Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
         * </p>
         * 
         * @param policyName
         *        Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * 
         * @param parameters
         *        Name of the parameter from the Review policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<PolicyParameter> parameters);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * 
         * @param parameters
         *        Name of the parameter from the Review policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PolicyParameter... parameters);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyParameter>.Builder} avoiding the need
         * to create one manually via {@link List<PolicyParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<PolicyParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<PolicyParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<PolicyParameter>)
         */
        Builder parameters(Consumer<PolicyParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private List<PolicyParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewPolicy model) {
            policyName(model.policyName);
            parameters(model.parameters);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Collection<PolicyParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(PolicyParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<PolicyParameter> parameters) {
            this.parameters = PolicyParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(PolicyParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<PolicyParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> PolicyParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<PolicyParameter.BuilderImpl> parameters) {
            this.parameters = PolicyParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public ReviewPolicy build() {
            return new ReviewPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
