/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains both ReviewResult and ReviewAction elements for a particular HIT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewReport implements SdkPojo, Serializable, ToCopyableBuilder<ReviewReport.Builder, ReviewReport> {
    private static final SdkField<List<ReviewResultDetail>> REVIEW_RESULTS_FIELD = SdkField
            .<List<ReviewResultDetail>> builder(MarshallingType.LIST)
            .getter(getter(ReviewReport::reviewResults))
            .setter(setter(Builder::reviewResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReviewResultDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReviewResultDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReviewActionDetail>> REVIEW_ACTIONS_FIELD = SdkField
            .<List<ReviewActionDetail>> builder(MarshallingType.LIST)
            .getter(getter(ReviewReport::reviewActions))
            .setter(setter(Builder::reviewActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReviewActionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReviewActionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEW_RESULTS_FIELD,
            REVIEW_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReviewResultDetail> reviewResults;

    private final List<ReviewActionDetail> reviewActions;

    private ReviewReport(BuilderImpl builder) {
        this.reviewResults = builder.reviewResults;
        this.reviewActions = builder.reviewActions;
    }

    /**
     * Returns true if the ReviewResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReviewResults() {
        return reviewResults != null && !(reviewResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ReviewResults objects for each action specified in the Review Policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReviewResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ReviewResults objects for each action specified in the Review Policy.
     */
    public List<ReviewResultDetail> reviewResults() {
        return reviewResults;
    }

    /**
     * Returns true if the ReviewActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReviewActions() {
        return reviewActions != null && !(reviewActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ReviewAction objects for each action specified in the Review Policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReviewActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ReviewAction objects for each action specified in the Review Policy.
     */
    public List<ReviewActionDetail> reviewActions() {
        return reviewActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reviewResults());
        hashCode = 31 * hashCode + Objects.hashCode(reviewActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewReport)) {
            return false;
        }
        ReviewReport other = (ReviewReport) obj;
        return Objects.equals(reviewResults(), other.reviewResults()) && Objects.equals(reviewActions(), other.reviewActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReviewReport").add("ReviewResults", reviewResults()).add("ReviewActions", reviewActions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReviewResults":
            return Optional.ofNullable(clazz.cast(reviewResults()));
        case "ReviewActions":
            return Optional.ofNullable(clazz.cast(reviewActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewReport, T> g) {
        return obj -> g.apply((ReviewReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewReport> {
        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewResults
         *        A list of ReviewResults objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewResults(Collection<ReviewResultDetail> reviewResults);

        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewResults
         *        A list of ReviewResults objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewResults(ReviewResultDetail... reviewResults);

        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReviewResultDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ReviewResultDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReviewResultDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #reviewResults(List<ReviewResultDetail>)}.
         * 
         * @param reviewResults
         *        a consumer that will call methods on {@link List<ReviewResultDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewResults(List<ReviewResultDetail>)
         */
        Builder reviewResults(Consumer<ReviewResultDetail.Builder>... reviewResults);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewActions
         *        A list of ReviewAction objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewActions(Collection<ReviewActionDetail> reviewActions);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewActions
         *        A list of ReviewAction objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewActions(ReviewActionDetail... reviewActions);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReviewActionDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ReviewActionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReviewActionDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #reviewActions(List<ReviewActionDetail>)}.
         * 
         * @param reviewActions
         *        a consumer that will call methods on {@link List<ReviewActionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewActions(List<ReviewActionDetail>)
         */
        Builder reviewActions(Consumer<ReviewActionDetail.Builder>... reviewActions);
    }

    static final class BuilderImpl implements Builder {
        private List<ReviewResultDetail> reviewResults = DefaultSdkAutoConstructList.getInstance();

        private List<ReviewActionDetail> reviewActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewReport model) {
            reviewResults(model.reviewResults);
            reviewActions(model.reviewActions);
        }

        public final Collection<ReviewResultDetail.Builder> getReviewResults() {
            return reviewResults != null ? reviewResults.stream().map(ReviewResultDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder reviewResults(Collection<ReviewResultDetail> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copy(reviewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(ReviewResultDetail... reviewResults) {
            reviewResults(Arrays.asList(reviewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(Consumer<ReviewResultDetail.Builder>... reviewResults) {
            reviewResults(Stream.of(reviewResults).map(c -> ReviewResultDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReviewResults(Collection<ReviewResultDetail.BuilderImpl> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copyFromBuilder(reviewResults);
        }

        public final Collection<ReviewActionDetail.Builder> getReviewActions() {
            return reviewActions != null ? reviewActions.stream().map(ReviewActionDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder reviewActions(Collection<ReviewActionDetail> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copy(reviewActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(ReviewActionDetail... reviewActions) {
            reviewActions(Arrays.asList(reviewActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(Consumer<ReviewActionDetail.Builder>... reviewActions) {
            reviewActions(Stream.of(reviewActions).map(c -> ReviewActionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReviewActions(Collection<ReviewActionDetail.BuilderImpl> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copyFromBuilder(reviewActions);
        }

        @Override
        public ReviewReport build() {
            return new ReviewReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
