/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkerBlocksResponse extends MTurkResponse implements
        ToCopyableBuilder<ListWorkerBlocksResponse.Builder, ListWorkerBlocksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWorkerBlocksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListWorkerBlocksResponse::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<List<WorkerBlock>> WORKER_BLOCKS_FIELD = SdkField
            .<List<WorkerBlock>> builder(MarshallingType.LIST)
            .getter(getter(ListWorkerBlocksResponse::workerBlocks))
            .setter(setter(Builder::workerBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NUM_RESULTS_FIELD, WORKER_BLOCKS_FIELD));

    private final String nextToken;

    private final Integer numResults;

    private final List<WorkerBlock> workerBlocks;

    private ListWorkerBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.workerBlocks = builder.workerBlocks;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of assignments on the page in the filtered results list, equivalent to the number of assignments
     * returned by this call.
     * </p>
     * 
     * @return The number of assignments on the page in the filtered results list, equivalent to the number of
     *         assignments returned by this call.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * Returns true if the WorkerBlocks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWorkerBlocks() {
        return workerBlocks != null && !(workerBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkerBlocks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
     */
    public List<WorkerBlock> workerBlocks() {
        return workerBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(workerBlocks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkerBlocksResponse)) {
            return false;
        }
        ListWorkerBlocksResponse other = (ListWorkerBlocksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(numResults(), other.numResults())
                && Objects.equals(workerBlocks(), other.workerBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWorkerBlocksResponse").add("NextToken", nextToken()).add("NumResults", numResults())
                .add("WorkerBlocks", workerBlocks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "WorkerBlocks":
            return Optional.ofNullable(clazz.cast(workerBlocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkerBlocksResponse, T> g) {
        return obj -> g.apply((ListWorkerBlocksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkerBlocksResponse> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of assignments on the page in the filtered results list, equivalent to the number of assignments
         * returned by this call.
         * </p>
         * 
         * @param numResults
         *        The number of assignments on the page in the filtered results list, equivalent to the number of
         *        assignments returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
         * </p>
         * 
         * @param workerBlocks
         *        The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerBlocks(Collection<WorkerBlock> workerBlocks);

        /**
         * <p>
         * The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
         * </p>
         * 
         * @param workerBlocks
         *        The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerBlocks(WorkerBlock... workerBlocks);

        /**
         * <p>
         * The list of WorkerBlocks, containing the collection of Worker IDs and reasons for blocking.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkerBlock>.Builder} avoiding the need to
         * create one manually via {@link List<WorkerBlock>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkerBlock>.Builder#build()} is called immediately and its
         * result is passed to {@link #workerBlocks(List<WorkerBlock>)}.
         * 
         * @param workerBlocks
         *        a consumer that will call methods on {@link List<WorkerBlock>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerBlocks(List<WorkerBlock>)
         */
        Builder workerBlocks(Consumer<WorkerBlock.Builder>... workerBlocks);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer numResults;

        private List<WorkerBlock> workerBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkerBlocksResponse model) {
            super(model);
            nextToken(model.nextToken);
            numResults(model.numResults);
            workerBlocks(model.workerBlocks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final Collection<WorkerBlock.Builder> getWorkerBlocks() {
            return workerBlocks != null ? workerBlocks.stream().map(WorkerBlock::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workerBlocks(Collection<WorkerBlock> workerBlocks) {
            this.workerBlocks = WorkerBlockListCopier.copy(workerBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerBlocks(WorkerBlock... workerBlocks) {
            workerBlocks(Arrays.asList(workerBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerBlocks(Consumer<WorkerBlock.Builder>... workerBlocks) {
            workerBlocks(Stream.of(workerBlocks).map(c -> WorkerBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWorkerBlocks(Collection<WorkerBlock.BuilderImpl> workerBlocks) {
            this.workerBlocks = WorkerBlockListCopier.copyFromBuilder(workerBlocks);
        }

        @Override
        public ListWorkerBlocksResponse build() {
            return new ListWorkerBlocksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
