/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntry;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntryListCopier;
import software.amazon.awssdk.services.mturk.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyParameter.getter(PolicyParameter::key)).setter(PolicyParameter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyParameter.getter(PolicyParameter::values)).setter(PolicyParameter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterMapEntry>> MAP_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyParameter.getter(PolicyParameter::mapEntries)).setter(PolicyParameter.setter(Builder::mapEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterMapEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD, MAP_ENTRIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> values;
    private final List<ParameterMapEntry> mapEntries;

    private PolicyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.mapEntries = builder.mapEntries;
    }

    public String key() {
        return this.key;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<String> values() {
        return this.values;
    }

    public boolean hasMapEntries() {
        return this.mapEntries != null && !(this.mapEntries instanceof SdkAutoConstructList);
    }

    public List<ParameterMapEntry> mapEntries() {
        return this.mapEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapEntries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyParameter)) {
            return false;
        }
        PolicyParameter other = (PolicyParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.mapEntries(), other.mapEntries());
    }

    public String toString() {
        return ToString.builder((String)"PolicyParameter").add("Key", (Object)this.key()).add("Values", this.values()).add("MapEntries", this.mapEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MapEntries": {
                return Optional.ofNullable(clazz.cast(this.mapEntries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyParameter, T> g) {
        return obj -> g.apply((PolicyParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterMapEntry> mapEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyParameter model) {
            this.key(model.key);
            this.values(model.values);
            this.mapEntries(model.mapEntries);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        public final Collection<ParameterMapEntry.Builder> getMapEntries() {
            return this.mapEntries != null ? (Collection)this.mapEntries.stream().map(ParameterMapEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapEntries(Collection<ParameterMapEntry> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copy(mapEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(ParameterMapEntry ... mapEntries) {
            this.mapEntries(Arrays.asList(mapEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... mapEntries) {
            this.mapEntries(Stream.of(mapEntries).map(c -> (ParameterMapEntry)((ParameterMapEntry.Builder)ParameterMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapEntries(Collection<ParameterMapEntry.BuilderImpl> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copyFromBuilder(mapEntries);
        }

        public PolicyParameter build() {
            return new PolicyParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyParameter> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder mapEntries(Collection<ParameterMapEntry> var1);

        public Builder mapEntries(ParameterMapEntry ... var1);

        public Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... var1);
    }
}

