/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkersWithQualificationTypeResponse extends MTurkResponse implements
        ToCopyableBuilder<ListWorkersWithQualificationTypeResponse.Builder, ListWorkersWithQualificationTypeResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWorkersWithQualificationTypeResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListWorkersWithQualificationTypeResponse::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<List<Qualification>> QUALIFICATIONS_FIELD = SdkField
            .<List<Qualification>> builder(MarshallingType.LIST)
            .getter(getter(ListWorkersWithQualificationTypeResponse::qualifications))
            .setter(setter(Builder::qualifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Qualification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Qualification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NUM_RESULTS_FIELD, QUALIFICATIONS_FIELD));

    private final String nextToken;

    private final Integer numResults;

    private final List<Qualification> qualifications;

    private ListWorkersWithQualificationTypeResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.qualifications = builder.qualifications;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of Qualifications on this page in the filtered results list, equivalent to the number of
     * Qualifications being returned by this call.
     * </p>
     * 
     * @return The number of Qualifications on this page in the filtered results list, equivalent to the number of
     *         Qualifications being returned by this call.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * Returns true if the Qualifications property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQualifications() {
        return qualifications != null && !(qualifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Qualification elements returned by this call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQualifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of Qualification elements returned by this call.
     */
    public List<Qualification> qualifications() {
        return qualifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(qualifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkersWithQualificationTypeResponse)) {
            return false;
        }
        ListWorkersWithQualificationTypeResponse other = (ListWorkersWithQualificationTypeResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(numResults(), other.numResults())
                && Objects.equals(qualifications(), other.qualifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWorkersWithQualificationTypeResponse").add("NextToken", nextToken())
                .add("NumResults", numResults()).add("Qualifications", qualifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "Qualifications":
            return Optional.ofNullable(clazz.cast(qualifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkersWithQualificationTypeResponse, T> g) {
        return obj -> g.apply((ListWorkersWithQualificationTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkersWithQualificationTypeResponse> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of Qualifications on this page in the filtered results list, equivalent to the number of
         * Qualifications being returned by this call.
         * </p>
         * 
         * @param numResults
         *        The number of Qualifications on this page in the filtered results list, equivalent to the number of
         *        Qualifications being returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The list of Qualification elements returned by this call.
         * </p>
         * 
         * @param qualifications
         *        The list of Qualification elements returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifications(Collection<Qualification> qualifications);

        /**
         * <p>
         * The list of Qualification elements returned by this call.
         * </p>
         * 
         * @param qualifications
         *        The list of Qualification elements returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifications(Qualification... qualifications);

        /**
         * <p>
         * The list of Qualification elements returned by this call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Qualification>.Builder} avoiding the need
         * to create one manually via {@link List<Qualification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Qualification>.Builder#build()} is called immediately and
         * its result is passed to {@link #qualifications(List<Qualification>)}.
         * 
         * @param qualifications
         *        a consumer that will call methods on {@link List<Qualification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualifications(List<Qualification>)
         */
        Builder qualifications(Consumer<Qualification.Builder>... qualifications);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer numResults;

        private List<Qualification> qualifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkersWithQualificationTypeResponse model) {
            super(model);
            nextToken(model.nextToken);
            numResults(model.numResults);
            qualifications(model.qualifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final Collection<Qualification.Builder> getQualifications() {
            return qualifications != null ? qualifications.stream().map(Qualification::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder qualifications(Collection<Qualification> qualifications) {
            this.qualifications = QualificationListCopier.copy(qualifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Qualification... qualifications) {
            qualifications(Arrays.asList(qualifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Consumer<Qualification.Builder>... qualifications) {
            qualifications(Stream.of(qualifications).map(c -> Qualification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQualifications(Collection<Qualification.BuilderImpl> qualifications) {
            this.qualifications = QualificationListCopier.copyFromBuilder(qualifications);
        }

        @Override
        public ListWorkersWithQualificationTypeResponse build() {
            return new ListWorkersWithQualificationTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
