/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Name of the parameter from the Review policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyParameter implements SdkPojo, Serializable, ToCopyableBuilder<PolicyParameter.Builder, PolicyParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyParameter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PolicyParameter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterMapEntry>> MAP_ENTRIES_FIELD = SdkField
            .<List<ParameterMapEntry>> builder(MarshallingType.LIST)
            .getter(getter(PolicyParameter::mapEntries))
            .setter(setter(Builder::mapEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterMapEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterMapEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD,
            MAP_ENTRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private final List<ParameterMapEntry> mapEntries;

    private PolicyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.mapEntries = builder.mapEntries;
    }

    /**
     * <p>
     * Name of the parameter from the list of Review Polices.
     * </p>
     * 
     * @return Name of the parameter from the list of Review Polices.
     */
    public String key() {
        return key;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values of the Parameter
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of values of the Parameter
     */
    public List<String> values() {
        return values;
    }

    /**
     * Returns true if the MapEntries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMapEntries() {
        return mapEntries != null && !(mapEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ParameterMapEntry objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMapEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of ParameterMapEntry objects.
     */
    public List<ParameterMapEntry> mapEntries() {
        return mapEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(mapEntries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyParameter)) {
            return false;
        }
        PolicyParameter other = (PolicyParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values())
                && Objects.equals(mapEntries(), other.mapEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyParameter").add("Key", key()).add("Values", values()).add("MapEntries", mapEntries())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "MapEntries":
            return Optional.ofNullable(clazz.cast(mapEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyParameter, T> g) {
        return obj -> g.apply((PolicyParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyParameter> {
        /**
         * <p>
         * Name of the parameter from the list of Review Polices.
         * </p>
         * 
         * @param key
         *        Name of the parameter from the list of Review Polices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The list of values of the Parameter
         * </p>
         * 
         * @param values
         *        The list of values of the Parameter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The list of values of the Parameter
         * </p>
         * 
         * @param values
         *        The list of values of the Parameter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * 
         * @param mapEntries
         *        List of ParameterMapEntry objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEntries(Collection<ParameterMapEntry> mapEntries);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * 
         * @param mapEntries
         *        List of ParameterMapEntry objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEntries(ParameterMapEntry... mapEntries);

        /**
         * <p>
         * List of ParameterMapEntry objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterMapEntry>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterMapEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterMapEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #mapEntries(List<ParameterMapEntry>)}.
         * 
         * @param mapEntries
         *        a consumer that will call methods on {@link List<ParameterMapEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapEntries(List<ParameterMapEntry>)
         */
        Builder mapEntries(Consumer<ParameterMapEntry.Builder>... mapEntries);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterMapEntry> mapEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyParameter model) {
            key(model.key);
            values(model.values);
            mapEntries(model.mapEntries);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        public final Collection<ParameterMapEntry.Builder> getMapEntries() {
            return mapEntries != null ? mapEntries.stream().map(ParameterMapEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapEntries(Collection<ParameterMapEntry> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copy(mapEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(ParameterMapEntry... mapEntries) {
            mapEntries(Arrays.asList(mapEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(Consumer<ParameterMapEntry.Builder>... mapEntries) {
            mapEntries(Stream.of(mapEntries).map(c -> ParameterMapEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMapEntries(Collection<ParameterMapEntry.BuilderImpl> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copyFromBuilder(mapEntries);
        }

        @Override
        public PolicyParameter build() {
            return new PolicyParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
