/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Locale data structure represents a geographical region or location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Locale implements SdkPojo, Serializable, ToCopyableBuilder<Locale.Builder, Locale> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Locale::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> SUBDIVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Locale::subdivision)).setter(setter(Builder::subdivision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdivision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD,
            SUBDIVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String country;

    private final String subdivision;

    private Locale(BuilderImpl builder) {
        this.country = builder.country;
        this.subdivision = builder.subdivision;
    }

    /**
     * <p>
     * The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the United
     * States of America.
     * </p>
     * 
     * @return The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the
     *         United States of America.
     */
    public String country() {
        return country;
    }

    /**
     * <p>
     * The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers to
     * the state of Washington.
     * </p>
     * 
     * @return The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA
     *         refers to the state of Washington.
     */
    public String subdivision() {
        return subdivision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(subdivision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale other = (Locale) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(subdivision(), other.subdivision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Locale").add("Country", country()).add("Subdivision", subdivision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Subdivision":
            return Optional.ofNullable(clazz.cast(subdivision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Locale, T> g) {
        return obj -> g.apply((Locale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Locale> {
        /**
         * <p>
         * The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to the
         * United States of America.
         * </p>
         * 
         * @param country
         *        The country of the locale. Must be a valid ISO 3166 country code. For example, the code US refers to
         *        the United States of America.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA refers
         * to the state of Washington.
         * </p>
         * 
         * @param subdivision
         *        The state or subdivision of the locale. A valid ISO 3166-2 subdivision code. For example, the code WA
         *        refers to the state of Washington.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivision(String subdivision);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private String subdivision;

        private BuilderImpl() {
        }

        private BuilderImpl(Locale model) {
            country(model.country);
            subdivision(model.subdivision);
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getSubdivision() {
            return subdivision;
        }

        @Override
        public final Builder subdivision(String subdivision) {
            this.subdivision = subdivision;
            return this;
        }

        public final void setSubdivision(String subdivision) {
            this.subdivision = subdivision;
        }

        @Override
        public Locale build() {
            return new Locale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
